/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class DeakinMinimumError
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Deakin Minimum-Error";
    private static final double PE_RATIO = 0.6329113924050632;
    private static final double AXES_RATIO = 0.5;
    private double kTerm_;
    private double kPlus1_;
    private double nTerm_;
    private double mTerm_;
    private double mn_;
    private double invN_;
    private double invM_;
    private double invMN_;
    private double invMRS_;
    private double mnOverRS_;

    public DeakinMinimumError(int width, int height) {
        this(width, height, 0, 0);
    }

    public DeakinMinimumError(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.0, 1.0);
        this.finishConstruction();
    }

    @Override
    protected final void prepareScaling() {
        this.kTerm_ = 1.7241379310344822;
        this.kPlus1_ = this.kTerm_ + 1.0;
        this.nTerm_ = this.kTerm_ * 1.5707963267948966 + 1.0;
        this.mTerm_ = Math.sqrt(1.0 * this.kPlus1_ / this.nTerm_);
        this.mn_ = this.mTerm_ * this.nTerm_;
        this.invN_ = 1.0 / this.nTerm_;
        this.invM_ = 1.0 / this.mTerm_;
        this.invMN_ = 1.0 / this.mn_;
        double widthFactor = Math.PI * this.kPlus1_ * this.invMN_;
        this.setMaxXYOverRS(widthFactor, widthFactor * 0.5);
    }

    @Override
    protected final void finishScaling() {
        this.invMRS_ = this.invM_ * this.invRS_;
        this.mnOverRS_ = this.mn_ * this.invRS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double phiRad = Math.toRadians(lat);
        double phiFactor = this.nTerm_ * Math.sin(phiRad);
        double alphaRad = phiRad;
        for (int iter = 0; iter < 33; ++iter) {
            double sinAlpha = Math.sin(alphaRad);
            double cosAlpha = Math.cos(alphaRad);
            double func = this.kTerm_ * alphaRad + sinAlpha - phiFactor;
            double dfunc = this.kTerm_ + cosAlpha;
            double dalphaRad = -func / dfunc;
            alphaRad += dalphaRad;
            if (Math.abs(dalphaRad) < 1.0E-5) break;
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double x = lambdaRad * (this.kTerm_ + Math.cos(alphaRad)) * this.invMN_;
        double y = this.mTerm_ * alphaRad;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double alphaRad = y * this.invMRS_;
        double sinAlpha = Math.sin(alphaRad);
        double phiRad = Math.asin((this.kTerm_ * alphaRad + sinAlpha) * this.invN_);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double cosAlpha = Math.cos(alphaRad);
        double lambdaRad = x * this.mnOverRS_ / (this.kTerm_ + cosAlpha);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        DeakinMinimumError deakinMinimumError = this;
        synchronized (deakinMinimumError) {
            double sinAlpha;
            double y;
            double alphaRad;
            double phiRad;
            for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.asin((this.kTerm_ * (alphaRad = (y = (double)iy + 0.5) * this.invMRS_) + (sinAlpha = Math.sin(alphaRad))) * this.invN_)) > 1.5707963267948966); ++iy) {
                double x;
                double lambdaRad;
                double phi = Math.toDegrees(phiRad);
                double cosAlpha = Math.cos(alphaRad);
                double xFactor = this.mnOverRS_ / (this.kTerm_ + cosAlpha);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

