/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalCylindric;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CentralCylindrical
extends GlobalCylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Central Cylindrical";
    private static final double DEFAULT_MAXLAT = 60.0;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = Math.tan(Math.toRadians(60.0));
    public double maxLat_ = 60.0;
    private final ProjDoubleParameter maxLatParam_ = new ProjDoubleParameter("Latitude at top of map", "Max. Latitude", "\u00b0", 60.0, 45.0, 89.0, true, false);

    public CentralCylindrical(int width, int height) {
        this(width, height, 0, 0);
    }

    public CentralCylindrical(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 4, width, height, xmargin, ymargin, Math.PI, MAX_Y_OVER_RS);
        this.addParameter(this.maxLatParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p == this.maxLatParam_) {
            this.setMaxLatitude(this.maxLatParam_.getValue());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setMaxLatitude(double lat) {
        this.maxLat_ = Math.abs(lat);
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        double heightFactor = Math.tan(Math.toRadians(this.maxLat_));
        this.setMaxXYOverRS(Math.PI, heightFactor);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > this.maxLat_) {
            return null;
        }
        double x = this.lonToLambdaRad(lon);
        double y = Math.tan(Math.toRadians(lat));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double phiRad = Math.atan(y * this.invRS_);
        if (Math.abs(Math.toDegrees(phiRad)) > this.maxLat_) {
            return null;
        }
        double lambdaRad = x * this.invRS_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        CentralCylindrical centralCylindrical = this;
        synchronized (centralCylindrical) {
            double y;
            double phiRad;
            double phi;
            for (int iy = 0; iy < this.dyMax_ && !((phi = Math.toDegrees(phiRad = Math.atan((y = (double)iy + 0.5) * this.invRS_))) > this.maxLat_); ++iy) {
                double x;
                double lambdaRad;
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.invRS_) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

