/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class CantersPseudocylindricW19
extends GlobalPseudocylindric {
    public static final String PROJECTION_NAME = "Canters Pseudocylindric W19";
    private static final double C10 = 0.8333;
    private static final double C12 = 0.3385;
    private static final double C14 = 0.0942;
    private static final double CP01 = 1.0114;
    private static final double CP03 = 0.0243;
    private static final double CP05 = -0.0391;
    private static final double THREE_CP03 = 0.07289999999999999;
    private static final double FIVE_CP05 = -0.1955;
    private static final double MAX_X_OVER_RS = 2.6178891582363746;
    private static final double MAX_Y_OVER_RS = 1.3089671679897534;

    public CantersPseudocylindricW19(int width, int height) {
        this(width, height, 0, 0);
    }

    public CantersPseudocylindricW19(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 8, width, height, xmargin, ymargin, 2.6178891582363746, 1.3089671679897534);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double phiRad2 = phiRad * phiRad;
        double x = lambdaRad * Math.cos(phiRad) * (0.8333 + phiRad2 * (0.3385 + phiRad2 * 0.0942));
        double y = phiRad * (1.0114 + phiRad2 * (0.0243 + phiRad2 * -0.0391));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        if (Math.abs(y) > this.ymRS_) {
            return null;
        }
        double yOverRS = y * this.invRS_;
        double phiRad = 1.5707963267948966 * y / this.ymRS_;
        for (int iter = 0; iter < 33; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double dphiRad = -(phiRad * (1.0114 + phiRad2 * (0.0243 + phiRad2 * -0.0391)) - yOverRS) / (1.0114 + phiRad2 * (0.07289999999999999 + phiRad2 * -0.1955));
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-5) break;
        }
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        if (Math.abs(phiRad) == 1.5707963267948966) {
            if (x == 0.0) {
                return new PointLL(this.lambdaC_, Math.toDegrees(phiRad));
            }
            return null;
        }
        double phiRad2 = phiRad * phiRad;
        double xFactor = this.invRS_ / ((0.8333 + phiRad2 * (0.3385 + phiRad2 * 0.0942)) * Math.cos(phiRad));
        double lambdaRad = x * xFactor;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        CantersPseudocylindricW19 cantersPseudocylindricW19 = this;
        synchronized (cantersPseudocylindricW19) {
            double y;
            double phiRad = 0.0;
            for (int iy = 0; iy < this.dyMax_ && !((y = (double)iy + 0.5) > this.ymRS_); ++iy) {
                double x;
                double lambdaRad;
                double phiRad2;
                double yOverRS = y * this.invRS_;
                phiRad += 1.0E-5;
                for (int iter = 0; iter < 33; ++iter) {
                    phiRad2 = phiRad * phiRad;
                    double dphiRad = -(phiRad * (1.0114 + phiRad2 * (0.0243 + phiRad2 * -0.0391)) - yOverRS) / (1.0114 + phiRad2 * (0.07289999999999999 + phiRad2 * -0.1955));
                    phiRad += dphiRad;
                    if (Math.abs(dphiRad) < 1.0E-5) break;
                }
                if (phiRad >= 1.5707963267948966) break;
                double phi = Math.toDegrees(phiRad);
                phiRad2 = phiRad * phiRad;
                double xFactor = this.invRS_ / ((0.8333 + phiRad2 * (0.3385 + phiRad2 * 0.0942)) * Math.cos(phiRad));
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * xFactor) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }
}

