/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ConcavePoleProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class CantersPolyconicW14
extends ConcavePoleProjection {
    public static final String PROJECTION_NAME = "Canters Polyconic W14";
    public static final int PROPERTIES = 32;
    private static final double C2 = 0.9305;
    private static final double C9 = -0.1968;
    private static final double C18 = -0.0067;
    private static final double C20 = 0.0076;
    private static final double C3P = 0.9305;
    private static final double C8P = 0.0394;
    private static final double C17P = 5.0E-4;
    private static final double C19P = -0.0115;
    private static final double MAX_X_OVER_RS = CantersPolyconicW14.equation17(Math.PI, 0.0);
    private static final double MAX_Y_OVER_RS = CantersPolyconicW14.equation18(Math.PI, 1.5707963267948966);

    public CantersPolyconicW14(int width, int height) {
        this(width, height, 0, 0);
    }

    public CantersPolyconicW14(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 32, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double x = CantersPolyconicW14.equation17(lambdaRad, phiRad);
        double y = CantersPolyconicW14.equation18(lambdaRad, phiRad);
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        double lambdaRad0 = 2.356194490192345;
        double phiRad0 = absY < 1.4616259820826512 * this.rS_ ? absY * this.invRS_ / 0.9305 : 1.5707863267948965;
        double[] llRad = this.iterateXY2LLRad(absX, absY, 2.356194490192345, phiRad0);
        if (llRad == null) {
            return null;
        }
        double lambda = Math.toDegrees(llRad[0]);
        double phi = Math.toDegrees(llRad[1]);
        if (x < 0.0) {
            lambda = -lambda;
        }
        if (y < 0.0) {
            phi = -phi;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        CantersPolyconicW14 cantersPolyconicW14 = this;
        synchronized (cantersPolyconicW14) {
            double yy = 1.4616259820826512 * this.rS_;
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double lambdaRad;
                double phiRad;
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                if (y < yy) {
                    phiRad = yOverRS / 0.9305;
                    lambdaRad = 0.0;
                } else {
                    phiRad = 1.5707863267948965;
                    lambdaRad = 1.5707963267948966;
                }
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double[] llRad = this.iterateXY2LLRad(x, y, lambdaRad, phiRad);
                    if (llRad == null) {
                        if (!(Math.abs(lambdaRad) > Math.PI)) continue;
                        continue block3;
                    }
                    lambdaRad = llRad[0] + 1.0E-5;
                    this.setInvPoints(ix, iy, Math.toDegrees(llRad[0]), Math.toDegrees(llRad[1]));
                }
            }
        }
    }

    private double[] iterateXY2LLRad(double x, double y, double lambdaRad0, double phiRad0) {
        double yOverRS = y * this.invRS_;
        double xOverRS = x * this.invRS_;
        double lambdaRad = lambdaRad0;
        double phiRad = phiRad0;
        boolean found = false;
        for (int iter = 0; iter < 33; ++iter) {
            double phiRad2 = phiRad * phiRad;
            double lambdaRad2 = lambdaRad * lambdaRad;
            double f1 = CantersPolyconicW14.equation17(lambdaRad, phiRad) - xOverRS;
            double f2 = CantersPolyconicW14.equation18(lambdaRad, phiRad) - yOverRS;
            double df1dPhi = lambdaRad * phiRad * (-0.3936 + -0.0134 * lambdaRad2 + 0.0304 * phiRad2);
            double df1dLambda = 0.9305 + phiRad2 * (-0.1968 + -0.0201 * lambdaRad2 + 0.0076 * phiRad2);
            double df2dPhi = 0.9305 + lambdaRad2 * (0.0394 + 5.0E-4 * lambdaRad2 + -0.0345 * phiRad2);
            double df2dLambda = phiRad * lambdaRad * (0.0788 + 0.002 * lambdaRad2 + -0.023 * phiRad2);
            double denom = df1dPhi * df2dLambda - df2dPhi * df1dLambda;
            double dphi = (f1 * df2dLambda - f2 * df1dLambda) / denom;
            double dlambda = (f2 * df1dPhi - f1 * df2dPhi) / denom;
            phiRad -= dphi;
            lambdaRad -= dlambda;
            if (!(Math.abs(dphi) < 1.0E-5 & Math.abs(dlambda) < 1.0E-5)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new double[]{lambdaRad, phiRad};
    }

    private static double equation17(double lambdaRad, double phiRad) {
        double lambdaRad2 = lambdaRad * lambdaRad;
        double phiRad2 = phiRad * phiRad;
        return lambdaRad * (0.9305 + phiRad2 * (-0.1968 + -0.0067 * lambdaRad2 + 0.0076 * phiRad2));
    }

    private static double equation18(double lambdaRad, double phiRad) {
        double lambdaRad2 = lambdaRad * lambdaRad;
        double phiRad2 = phiRad * phiRad;
        return phiRad * (0.9305 + lambdaRad2 * (0.0394 + 5.0E-4 * lambdaRad2 + -0.0115 * phiRad2));
    }
}

