/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;

public class BreusingHarmonic
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Breusing Harmonic";
    private static final double MAX_CLIP_ANGLE = 180.0;
    private static final double DEFAULT_CLIP_ANGLE = 90.0;
    private double constB_;
    private double invBRS_;

    public BreusingHarmonic(int width, int height) {
        this(width, height, 0, 0);
    }

    public BreusingHarmonic(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addClipAngleParameter(90.0, 180.0, true);
        this.addAzimuthalFillParameter();
        this.finishConstruction();
    }

    @Override
    protected final void prepareScaling() {
        double halfBeta_ = 0.5 * this.edgeAngleRad_;
        double quarterBeta_ = 0.25 * this.edgeAngleRad_;
        double sinQuarterBeta = Math.sin(quarterBeta_);
        double tanQuarterBeta = Math.tan(quarterBeta_);
        double sinsqQuarterBeta = sinQuarterBeta * sinQuarterBeta;
        double tansqQuarterBeta = tanQuarterBeta * tanQuarterBeta;
        double cosHalfBeta_ = Math.cos(halfBeta_);
        double secHalfBeta_ = 1.0 / cosHalfBeta_;
        double lnSecHalfBeta_ = Math.log(secHalfBeta_);
        this.constB_ = 4.0 * sinsqQuarterBeta / (lnSecHalfBeta_ - tansqQuarterBeta);
        double quarterZ = 0.25 * this.edgeAngleRad_;
        double rhoEdgeOverR = this.constB_ * Math.tan(quarterZ);
        this.setMaxXYOverRS(rhoEdgeOverR);
    }

    @Override
    protected final void finishScaling() {
        if (this.fillCorners_) {
            double quarterZ = 0.25 * Math.toRadians(180.0);
            double rhoBOverR = this.constB_ * Math.tan(quarterZ);
            this.rhoBorder_ = rhoBOverR * this.rS_;
        } else {
            this.rhoBorder_ = this.xmRS_;
        }
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
        this.invBRS_ = this.invRS_ / this.constB_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        double z = Math.acos(cosZ);
        double quarterZ = 0.25 * z;
        return this.constB_ * Math.tan(quarterZ) / Math.sin(z);
    }

    @Override
    protected double getZRadForRho(double rho) {
        return 4.0 * Math.atan(rho * this.invBRS_);
    }
}

