/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.GlobalPseudocylindric;
import gov.nasa.giss.map.proj.ProjBooleanParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.map.proj.ProjectionUtils;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaconGlobular
extends GlobalPseudocylindric {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Bacon Globular";
    public static final int PROPERTIES = 0x4000008;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 1.5707963267948966;
    private final ProjBooleanParameter globalParam_ = new ProjBooleanParameter("Show full globe rather than hemisphere", "Global", true);

    public BaconGlobular(int width, int height) {
        this(width, height, 0, 0);
    }

    public BaconGlobular(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x4000008, width, height, xmargin, ymargin, Math.PI, 1.5707963267948966);
        this.addParameter(this.globalParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p == this.globalParam_) {
            this.setGlobal(this.globalParam_.isSelected());
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    private void setGlobal(boolean global) {
        super.setGlobalProt(global);
    }

    @Override
    protected final void prepareScaling() {
        if (this.isGlobal()) {
            this.setMaxXYOverRS(Math.PI, 1.5707963267948966);
        } else {
            this.setMaxXYOverRS(1.5707963267948966);
        }
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double absLambdaRad = Math.abs(lambdaRad);
        if (absLambdaRad > Math.PI) {
            return null;
        }
        if (!this.isGlobal() && absLambdaRad > 1.5707963267948966) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        double y = 1.5707963267948966 * Math.sin(phiRad);
        double x = 0.0;
        if (absLambdaRad != 0.0) {
            double f = 0.5 * (absLambdaRad + 2.4674011002723395 / absLambdaRad);
            x = absLambdaRad - f + Math.sqrt(f * f - y * y);
        }
        if (lambdaRad < 0.0) {
            x = -x;
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double yOverRS = y * this.invRS_;
        double phiRad = Math.asin(yOverRS * 0.6366197723675814);
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double lambdaRad = 0.0;
        double y2OverR2S2 = yOverRS * yOverRS;
        if (x != 0.0) {
            double xOverRS = Math.abs(x) * this.invRS_;
            lambdaRad = Math.abs(phiRad) < 1.5707963267948966 ? 0.7853981633974483 : 2.356194490192345;
            for (int iter = 0; iter < 33; ++iter) {
                double lambdaRad2 = lambdaRad * lambdaRad;
                double f = 0.5 * (lambdaRad + 2.4674011002723395 / lambdaRad);
                double sqrtTerm = Math.sqrt(f * f - y2OverR2S2);
                double dfDLambda = 0.5 * (1.0 - 2.4674011002723395 / lambdaRad2);
                double func = lambdaRad - f + sqrtTerm - xOverRS;
                double dfunc = 1.0 - dfDLambda + f * dfDLambda / sqrtTerm;
                double dlambdaRad = -func / dfunc;
                lambdaRad += dlambdaRad;
                if (Math.abs(dlambdaRad) < 1.0E-5) break;
            }
            if (lambdaRad > Math.PI) {
                return null;
            }
            if (!this.isGlobal() && lambdaRad > 1.5707963267948966) {
                return null;
            }
            if (x < 0.0) {
                lambdaRad = -lambdaRad;
            }
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        BaconGlobular baconGlobular = this;
        synchronized (baconGlobular) {
            double y;
            double yOverRS;
            double phiRad;
            block3: for (int iy = 0; iy < this.dyMax_ && !((phiRad = Math.asin((yOverRS = (y = (double)iy + 0.5) * this.invRS_) * 0.6366197723675814)) > 1.5707963267948966); ++iy) {
                double phi = Math.toDegrees(phiRad);
                double y2OverR2S2 = yOverRS * yOverRS;
                double lambdaRad = phi < 90.0 ? 1.0E-5 : 1.5708063267948966;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    for (int iter = 0; iter < 33; ++iter) {
                        double lambdaRad2 = lambdaRad * lambdaRad;
                        double f = 0.5 * (lambdaRad + 2.4674011002723395 / lambdaRad);
                        double sqrtTerm = Math.sqrt(f * f - y2OverR2S2);
                        double dfDLambda = 0.5 * (1.0 - 2.4674011002723395 / lambdaRad2);
                        double func = lambdaRad - f + sqrtTerm - xOverRS;
                        double dfunc = 1.0 - dfDLambda + f * dfDLambda / sqrtTerm;
                        double dlambdaRad = -func / dfunc;
                        lambdaRad += dlambdaRad;
                        if (Math.abs(dlambdaRad) < 1.0E-5) break;
                    }
                    if (lambdaRad > Math.PI || !this.isGlobal() && lambdaRad > 1.5707963267948966) continue block3;
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        if (this.isGlobal()) {
            super.drawBorderLines(g2d);
            return;
        }
        double r = Math.min(this.dxMax_, this.dyMax_);
        ProjectionUtils.drawEllipse(g2d, this.outCenterX_, this.outCenterY_, r, r);
    }
}

