/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.PointPoleProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;

public class AmericanPolyconicGlobal
extends PointPoleProjection {
    public static final String PROJECTION_NAME = "American Polyconic (Global)";
    public static final int PROPERTIES = 32;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = 2.407633359663;

    public AmericanPolyconicGlobal(int width, int height) {
        this(width, height, 0, 0);
    }

    public AmericanPolyconicGlobal(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 32, width, height, xmargin, ymargin, Math.PI, 2.407633359663);
        this.finishConstruction();
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Latitude must be in range [-90\u0080,90\u0080].");
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        double x = 0.0;
        double y = 0.0;
        if (lambdaRad == 0.0) {
            y = phiRad;
        } else if (phiRad == 0.0) {
            x = lambdaRad;
        } else {
            double sinPhi = Math.sin(phiRad);
            double tanPhi = Math.tan(phiRad);
            double cotPhi = 1.0 / tanPhi;
            double thetaRad = lambdaRad * sinPhi;
            x = cotPhi * Math.sin(thetaRad);
            y = phiRad + cotPhi * (1.0 - Math.cos(thetaRad));
        }
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        if (absX > (double)this.dxMax_ || absY > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = absX * this.invRS_;
        double yOverRS = absY * this.invRS_;
        if (y == 0.0) {
            if (Math.abs(xOverRS) > Math.PI) {
                return null;
            }
            return new PointLL(this.lambdaC_ + xOverRS, 0.0);
        }
        if (x == 0.0) {
            if (Math.abs(yOverRS) > 1.5707963267948966) {
                return null;
            }
            return new PointLL(this.lambdaC_, yOverRS);
        }
        double phiRad0 = absY < 1.5707963267948966 * this.rS_ ? yOverRS : 1.5707963267948966 - Math.toRadians(41.0 * (yOverRS - 1.5707963267948966) / 0.8368370328681034);
        double[] llRad = this.iterateXY2LLRad(absX, absY, phiRad0);
        if (llRad == null) {
            return null;
        }
        double lambda = Math.toDegrees(llRad[0]);
        double phi = Math.toDegrees(llRad[1]);
        if (x < 0.0) {
            lambda = -lambda;
        }
        if (y < 0.0) {
            phi = -phi;
        }
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        AmericanPolyconicGlobal americanPolyconicGlobal = this;
        synchronized (americanPolyconicGlobal) {
            double yyy = 1.5707963267948966 * this.rS_;
            for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                double phiRad = y < yyy ? yOverRS : 1.5707963267948966 - Math.toRadians(41.0 * (yOverRS - 1.5707963267948966) / 0.8368370328681034);
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double[] llRad = this.iterateXY2LLRad(x, y, phiRad);
                    if (llRad == null) continue;
                    double lambdaRad = llRad[0];
                    phiRad = llRad[1];
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private double[] iterateXY2LLRad(double x, double y, double phiRad0) {
        double sinPhi;
        double tanPhi;
        double yOverRS = y * this.invRS_;
        double xOverRS = x * this.invRS_;
        double yy = yOverRS;
        double rho2 = xOverRS * xOverRS + yOverRS * yOverRS;
        double twoYY = 2.0 * yy;
        double phiRad = phiRad0;
        boolean found = false;
        for (int iter = 0; iter < 33; ++iter) {
            double twoPhiRad = 2.0 * phiRad;
            double phiRad2 = phiRad * phiRad;
            tanPhi = Math.tan(phiRad);
            double phiTanPhi = phiRad * tanPhi;
            double sec2Phi = 1.0 + tanPhi * tanPhi;
            double func = twoYY * (phiTanPhi + 1.0) - twoPhiRad - (phiRad2 + rho2) * tanPhi;
            double dfunc = twoYY * (tanPhi + phiRad * sec2Phi) - 2.0 - twoPhiRad * tanPhi - (phiRad2 + rho2) * sec2Phi;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (!(Math.abs(dphiRad) < 1.0E-5)) continue;
            found = true;
            break;
        }
        if (!found) {
            return null;
        }
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        tanPhi = Math.tan(phiRad);
        double cosTheta = 1.0 - (yOverRS - phiRad) * tanPhi;
        double thetaRad = Math.acos(cosTheta);
        double lambdaRad = thetaRad / (sinPhi = Math.sin(phiRad));
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new double[]{lambdaRad, phiRad};
    }
}

