/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.AzimuthalProjection;

public class Airy
extends AzimuthalProjection {
    public static final String PROJECTION_NAME = "Airy";
    private static final double MAX_CLIP_ANGLE = 150.0;
    private static final double MAX_CLIP_ANGLE_RAD = Math.toRadians(150.0);
    private static final double DEFAULT_CLIP_ANGLE = 90.0;
    private double constB_;

    public Airy(int width, int height) {
        this(width, height, 0, 0);
    }

    public Airy(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x200040, width, height, xmargin, ymargin, 1.0, 1.0);
        this.addClipAngleParameter(90.0, 150.0, false);
        this.addAzimuthalFillParameter();
        this.finishConstruction();
    }

    @Override
    protected final void prepareScaling() {
        double halfBeta = 0.5 * this.edgeAngleRad_;
        double cosHalfBeta = Math.cos(halfBeta);
        double tanHalfBeta = Math.tan(halfBeta);
        double secHalfBeta = 1.0 / cosHalfBeta;
        double lnSecHalfBeta = Math.log(secHalfBeta);
        double tansqHalfBeta = tanHalfBeta * tanHalfBeta;
        double cotsqHalfBeta = 1.0 / tansqHalfBeta;
        this.constB_ = cotsqHalfBeta * lnSecHalfBeta;
        double halfZ = halfBeta;
        double cosHalfZ = cosHalfBeta;
        double tanHalfZ = tanHalfBeta;
        double secHalfZ = secHalfBeta;
        double cotHalfZ = 1.0 / tanHalfZ;
        double lnSecHalfZ = Math.log(secHalfZ);
        double rhoEdgeOverR = 2.0 * (cotHalfZ * lnSecHalfZ + tanHalfZ * this.constB_);
        this.setMaxXYOverRS(rhoEdgeOverR);
    }

    @Override
    protected final void finishScaling() {
        if (this.fillCorners_) {
            double halfZ = 0.5 * Math.toRadians(150.0);
            double cosHalfZ = Math.cos(halfZ);
            double tanHalfZ = Math.tan(halfZ);
            double secHalfZ = 1.0 / cosHalfZ;
            double cotHalfZ = 1.0 / tanHalfZ;
            double lnSecHalfZ = Math.log(secHalfZ);
            double rhoBOverR = 2.0 * (cotHalfZ * lnSecHalfZ + tanHalfZ * this.constB_);
            this.rhoBorder_ = rhoBOverR * this.rS_;
        } else {
            this.rhoBorder_ = this.xmRS_;
        }
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
    }

    @Override
    protected double getKForCosZ(double cosZ) {
        if (cosZ == 1.0) {
            return 0.5 * (1.0 + this.constB_);
        }
        double onePCosZ = 1.0 + cosZ;
        double oneMCosZ = 1.0 - cosZ;
        return -Math.log(0.5 * onePCosZ) / oneMCosZ + 2.0 * this.constB_ / onePCosZ;
    }

    @Override
    protected final double getZRadForRho(double rho) {
        double rhoOverRS = rho * this.invRS_;
        double z = this.fillCorners_ ? rho * MAX_CLIP_ANGLE_RAD / this.rhoBorder_ : rho * this.edgeAngleRad_ / this.rhoBorder_;
        for (int iter = 0; iter < 33; ++iter) {
            double dfunc;
            double halfZ = 0.5 * z;
            double cosHalfZ = Math.cos(halfZ);
            double secHalfZ = 1.0 / cosHalfZ;
            double secsqHalfZ = secHalfZ * secHalfZ;
            double lnSecHalfZ = Math.log(secHalfZ);
            double sinHalfZ = Math.sin(halfZ);
            double sinsqHalfZ = sinHalfZ * sinHalfZ;
            double cscsqHalfZ = 1.0 / sinsqHalfZ;
            double tanHalfZ = Math.tan(halfZ);
            double cotHalfZ = 1.0 / tanHalfZ;
            double func = 2.0 * (cotHalfZ * lnSecHalfZ + this.constB_ * tanHalfZ) - rhoOverRS;
            double dz = -func / (dfunc = -cscsqHalfZ * lnSecHalfZ + 1.0 + this.constB_ * secsqHalfZ);
            if (Double.isNaN(dz)) {
                z = this.edgeAngleRad_ - Math.PI / 180;
                continue;
            }
            z += dz;
            if (Math.abs(dz) < 1.0E-5) break;
        }
        return z;
    }
}

