/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.overlay;

import gov.nasa.giss.map.OverlayFactory;
import gov.nasa.giss.map.overlay.MapOverlay;
import gov.nasa.giss.map.overlay.OutlineArea;
import gov.nasa.giss.map.overlay.OutlineOverlay;
import gov.nasa.giss.math.PointLL;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CNOBaker {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void main(String ... args) {
        File f = new File(args[0]);
        new CNOBaker(f);
    }

    private CNOBaker(File f) {
        block14: {
            try {
                MapOverlay o = OverlayFactory.open(f);
                if (!(o instanceof OutlineOverlay)) {
                    LOGGER.error("Input file is not a text outline overlay.");
                    System.exit(1);
                }
                OutlineOverlay outline = (OutlineOverlay)o;
                String name = f.getName() + ".cnob";
                File bf = new File(f.getParent(), name);
                if (bf.exists()) {
                    LOGGER.error("File '{}' already exists.", (Object)name);
                    System.exit(1);
                }
                try (FileOutputStream fos = new FileOutputStream(bf);
                     DataOutputStream dos = new DataOutputStream(fos);){
                    CNOBaker.writeContent(dos, outline);
                }
            }
            catch (Exception exc) {
                if (!LOGGER.isTraceEnabled()) break block14;
                exc.printStackTrace();
            }
        }
    }

    private static void writeContent(DataOutputStream dos, OutlineOverlay outline) throws IOException {
        dos.writeBytes("GISSCNOB");
        int isize = outline.size();
        for (int i = 0; i < isize; ++i) {
            OutlineArea area = outline.getArea(i);
            int jsize = area.size();
            for (int j = 0; j < jsize; ++j) {
                PointLL[] points = area.getSegment(j).getPoints();
                if (points.length <= 1) continue;
                for (PointLL p : points) {
                    int lon1000 = (int)(p.getLon() * 1000.0);
                    dos.writeInt(lon1000);
                    int lat1000 = (int)(p.getLat() * 1000.0);
                    dos.writeInt(lat1000);
                }
                dos.writeInt(999999);
            }
        }
    }
}

