/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map;

import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LonLatEdges {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final LonLatEdges ENTIRE_GLOBE = new LonLatEdges(-180.0, 90.0, 180.0, -90.0);
    private static final PrintfFormat XFORMAT = new PrintfFormat("%.7f");
    private double west_;
    private double north_;
    private double east_;
    private double south_;

    public LonLatEdges(double[] edges) {
        Objects.requireNonNull(edges, "Edges array cannot be null.");
        if (edges.length != 4) {
            throw new IllegalArgumentException("Edges array must have length 4.");
        }
        this.set(edges[0], edges[1], edges[2], edges[3]);
    }

    public LonLatEdges(double west, double north, double east, double south) {
        this.set(west, north, east, south);
    }

    private void set(double west, double north, double east, double south) {
        if (west == east && north == south) {
            if (Math.abs(north) > 90.0) {
                LOGGER.trace("Unreasonable point lat: {}", (Object)north);
                throw new IllegalArgumentException("North lat is outside range [-90,90].");
            }
            this.south_ = this.north_ = north;
            if (Math.abs(west) > 7200.0) {
                LOGGER.trace("Unreasonable point lon: {}", (Object)west);
                throw new IllegalArgumentException("East and west lons must have reasonable values.");
            }
            this.east_ = this.west_ = MapUtils.normalizeMP180(west);
        }
        if (Math.abs(north) > 90.0) {
            LOGGER.trace("Unreasonable north lat: {}", (Object)north);
            throw new IllegalArgumentException("North lat is outside range [-90,90].");
        }
        if (Math.abs(south) > 90.0) {
            LOGGER.trace("Unreasonable south lat: {}", (Object)south);
            throw new IllegalArgumentException("South lat is outside range [-90,90].");
        }
        if (south > north) {
            LOGGER.trace("Unreasonable lats: south {} > north {}", (Object)south, (Object)north);
            throw new IllegalArgumentException("South lat cannot be greater than north lat.");
        }
        this.north_ = north;
        this.south_ = south;
        if (Math.abs(west) > 7200.0 || Math.abs(east) > 7200.0) {
            LOGGER.trace("Unreasonable lon: west {}, east {}", (Object)west, (Object)east);
            throw new IllegalArgumentException("East and west lons must have reasonable values.");
        }
        double dlon = east - west;
        if (Math.abs(dlon) > 360.0) {
            LOGGER.trace("Unreasonable d-lon: {}", (Object)dlon);
            throw new IllegalArgumentException("East and west lons must be within 360 deg.");
        }
        this.west_ = MapUtils.normalizeMP180(west);
        this.east_ = dlon < 0.0 ? this.west_ + dlon + 360.0 : this.west_ + dlon;
    }

    public double getWest() {
        return this.west_;
    }

    public double getNorth() {
        return this.north_;
    }

    public double getEast() {
        return this.east_;
    }

    public double getSouth() {
        return this.south_;
    }

    public double[] asArray() {
        return new double[]{this.west_, this.north_, this.east_, this.south_};
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(72);
        sb.append("[West: ").append(XFORMAT.sprintfx(this.west_)).append(", North: ").append(XFORMAT.sprintfx(this.north_)).append(", East: ").append(XFORMAT.sprintfx(this.east_)).append(", South: ").append(XFORMAT.sprintfx(this.south_)).append(']');
        return sb.toString();
    }
}

