/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map;

import gov.nasa.giss.map.LonLatEdges;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DayNightMap {
    private static final Logger LOGGER = LoggerFactory.getLogger(DayNightMap.class);
    private static final double UNKNOWN = 9999.0;
    private static final Color TRANSPARENT = new Color(0xCCCCCC, true);
    private static final double DFLT_SUB_LON = -30.0;
    private static final double DFLT_SUB_LAT = 0.0;
    private Image sourceImage_;
    private BufferedImage targetImage_;
    private int srcWidth_ = 2;
    private int srcHeight_ = 1;
    private int outWidth_;
    private int outHeight_;
    private Color background_ = TRANSPARENT;
    private int shadowWidth_;
    private int shadowHeight_;
    private double maxOpaque_;
    private Color shade_;
    private int darkSkip_;
    private double wBound_;
    private double eBound_;
    private double nBound_;
    private double sBound_;
    private double[] mapLon_;
    private double[] cosMapColat_;
    private double[] sinMapColat_;
    private double[][] cosC_;
    private double[] cosDTheta_;
    private double subsolarLon_;
    private double cosSubsolarColat_;
    private double sinSubsolarColat_;
    private double brightAngle_ = 81.0;
    private double cosBrightAngle_ = Math.cos(Math.toRadians(this.brightAngle_));
    private boolean needsInit_ = true;
    private boolean needsRedraw_ = true;

    public DayNightMap(BufferedImage img) {
        this(img, LonLatEdges.ENTIRE_GLOBE, img.getWidth(), img.getHeight());
    }

    public DayNightMap(int width, int height) {
        this(null, LonLatEdges.ENTIRE_GLOBE, width, height);
    }

    public DayNightMap(Image img, int width, int height) {
        this(img, LonLatEdges.ENTIRE_GLOBE, width, height);
    }

    public DayNightMap(Image img, LonLatEdges bounds, int width, int height) {
        this.setSize(width, height);
        this.setSource(img, bounds);
        this.initMe();
        this.setSubsolarPoint(-30.0, 0.0);
        this.setBrightAngle(81.0);
        this.setDarkness(60);
    }

    public void setSource(Image img) {
        this.setSource(img, LonLatEdges.ENTIRE_GLOBE);
    }

    public void setSource(Image img, LonLatEdges bounds) {
        this.sourceImage_ = img;
        if (this.sourceImage_ == null) {
            this.srcWidth_ = 200;
            this.srcHeight_ = 100;
        } else {
            this.srcWidth_ = this.sourceImage_.getWidth(null);
            this.srcHeight_ = this.sourceImage_.getHeight(null);
        }
        this.wBound_ = bounds.getWest();
        this.nBound_ = bounds.getNorth();
        this.eBound_ = bounds.getEast();
        this.sBound_ = bounds.getSouth();
        this.needsRedraw_ = true;
    }

    public void setSize(int width, int height) {
        this.outWidth_ = width;
        this.outHeight_ = height;
        if (this.outWidth_ < 3000) {
            this.shadowWidth_ = this.outWidth_;
            this.shadowHeight_ = this.outHeight_;
        } else {
            this.shadowWidth_ = 3000;
            this.shadowHeight_ = 1500;
        }
        this.targetImage_ = new BufferedImage(this.outWidth_, this.outHeight_, 2);
        this.needsInit_ = true;
    }

    public void setBackground(Color bgcolor) {
        this.background_ = bgcolor;
    }

    private void initMe() {
        double lonWidth = this.eBound_ - this.wBound_;
        double latHeight = this.nBound_ - this.sBound_;
        double xpixPerDeg = (double)this.shadowWidth_ / lonWidth;
        double ypixPerDeg = (double)this.shadowHeight_ / latHeight;
        double xdegPerPix = 1.0 / xpixPerDeg;
        double ydegPerPix = 1.0 / ypixPerDeg;
        this.darkSkip_ = this.shadowWidth_ / 8;
        this.cosDTheta_ = new double[this.shadowWidth_ + 1];
        this.cosC_ = new double[this.shadowHeight_ + 1][this.shadowWidth_ + 1];
        this.mapLon_ = new double[this.shadowWidth_ + 1];
        double[] mapLat = new double[this.shadowHeight_ + 1];
        this.cosMapColat_ = new double[this.shadowHeight_ + 1];
        this.sinMapColat_ = new double[this.shadowHeight_ + 1];
        for (int i = 0; i <= this.shadowWidth_; ++i) {
            this.mapLon_[i] = this.wBound_ + xdegPerPix * (double)i;
        }
        for (int j = 0; j <= this.shadowHeight_; ++j) {
            mapLat[j] = this.nBound_ - ydegPerPix * (double)j;
            double mapColat = 90.0 - mapLat[j];
            this.cosMapColat_[j] = Math.cos(Math.toRadians(mapColat));
            this.sinMapColat_[j] = Math.sin(Math.toRadians(mapColat));
        }
        this.needsRedraw_ = true;
    }

    public int getDarkness() {
        return (int)(100.0 * this.maxOpaque_ + 0.5);
    }

    public void setDarkness(int dark) {
        if (dark < 0 || dark > 100) {
            throw new IllegalArgumentException("Darkness must be in range 0 to 100.");
        }
        this.setDarkness(0.01 * (double)dark);
    }

    public void setDarkness(double dark) {
        if (dark < 0.0 || dark > 1.0) {
            throw new IllegalArgumentException("Darkness must be in range 0.0 to 1.0.");
        }
        LOGGER.trace("darkness {}", (Object)dark);
        this.maxOpaque_ = dark;
        this.shade_ = new Color(0.0f, 0.0f, 0.0f, (float)dark);
        this.needsRedraw_ = true;
    }

    public void setSubsolarPoint(double lon, double lat) {
        if (Math.abs(lat) > 90.0) {
            throw new IllegalArgumentException("Subsolar lat must be in range -90. to 90.");
        }
        this.subsolarLon_ = lon;
        double subsolarLat = lat;
        this.cosSubsolarColat_ = Math.cos(Math.toRadians(90.0 - subsolarLat));
        this.sinSubsolarColat_ = Math.sin(Math.toRadians(90.0 - subsolarLat));
        this.needsRedraw_ = true;
    }

    public double getBrightAngle() {
        return this.brightAngle_;
    }

    public void setBrightAngle(double angle) {
        if (angle < 0.0 || angle > 90.0) {
            throw new IllegalArgumentException("Bright angle must be in range 0. to 90.");
        }
        this.brightAngle_ = angle;
        this.cosBrightAngle_ = Math.cos(Math.toRadians(angle));
        this.needsRedraw_ = true;
    }

    public BufferedImage getMap() {
        if (this.needsInit_) {
            this.initMe();
        }
        if (this.needsRedraw_) {
            this.drawMap();
        }
        return this.targetImage_;
    }

    private void drawMap() {
        LOGGER.trace("");
        BufferedImage shadowImage = new BufferedImage(this.shadowWidth_, this.shadowHeight_, 2);
        Graphics2D shadowG2D = shadowImage.createGraphics();
        shadowG2D.setColor(TRANSPARENT);
        shadowG2D.fillRect(0, 0, this.shadowWidth_, this.shadowHeight_);
        for (int i = 0; i <= this.shadowWidth_; ++i) {
            this.cosDTheta_[i] = 9999.0;
            for (int j = 0; j <= this.shadowHeight_; ++j) {
                this.cosC_[j][i] = 9999.0;
            }
        }
        for (int j = 0; j <= this.shadowHeight_; j += this.darkSkip_) {
            int jx = Math.min(this.shadowHeight_, j + this.darkSkip_);
            for (int i = 0; i < this.shadowWidth_; i += this.darkSkip_) {
                int ix = Math.min(this.shadowWidth_, i + this.darkSkip_);
                this.drawDarkness(shadowG2D, i, ix, j, jx);
            }
        }
        Graphics2D targetG2D = this.targetImage_.createGraphics();
        targetG2D.setColor(this.background_);
        targetG2D.fillRect(0, 0, this.outWidth_, this.outHeight_);
        if (this.sourceImage_ != null) {
            targetG2D.drawImage(this.sourceImage_, 0, 0, this.outWidth_, this.outHeight_, 0, 0, this.srcWidth_, this.srcHeight_, null);
        }
        targetG2D.drawImage(shadowImage, 0, 0, this.outWidth_, this.outHeight_, 0, 0, this.shadowWidth_, this.shadowHeight_, null);
        targetG2D.dispose();
        shadowG2D.dispose();
        this.needsRedraw_ = false;
    }

    private void drawDarkness(Graphics2D g2d, int left, int right, int top, int bottom) {
        if (left < 0 || bottom < 0) {
            return;
        }
        if (right > this.shadowWidth_ || bottom > this.shadowHeight_) {
            return;
        }
        int width = right - left;
        int height = bottom - top;
        if (width < 1 || height < 1) {
            return;
        }
        boolean isDark = true;
        double minCos = 1.0;
        for (int k = 0; k < 4; ++k) {
            int jx;
            int ix;
            if (k == 0) {
                ix = left;
                jx = top;
            } else if (k == 1) {
                ix = right;
                jx = top;
            } else if (k == 2) {
                ix = right;
                jx = bottom;
            } else {
                ix = left;
                jx = bottom;
            }
            if (this.cosC_[jx][ix] == 9999.0) {
                if (this.cosDTheta_[ix] == 9999.0) {
                    this.cosDTheta_[ix] = Math.cos(Math.toRadians(this.subsolarLon_ - this.mapLon_[ix]));
                }
                this.cosC_[jx][ix] = this.cosSubsolarColat_ * this.cosMapColat_[jx] + this.sinSubsolarColat_ * this.sinMapColat_[jx] * this.cosDTheta_[ix];
            }
            if (this.cosC_[jx][ix] > 0.0) {
                isDark = false;
            }
            minCos = Math.min(minCos, this.cosC_[jx][ix]);
        }
        if (isDark) {
            g2d.setColor(this.shade_);
            g2d.fillRect(left, top, width, height);
        } else if (!(minCos > this.cosBrightAngle_)) {
            if (minCos > 0.0 && width < 2 && height < 2) {
                double opacity = this.maxOpaque_ * (1.0 - minCos / this.cosBrightAngle_);
                if (opacity < 0.0) {
                    opacity = 0.0;
                } else if (opacity > this.maxOpaque_) {
                    opacity = this.maxOpaque_;
                }
                g2d.setColor(new Color(0.0f, 0.0f, 0.0f, (float)opacity));
                g2d.fillRect(left, top, width, height);
            } else if (width < 2 && height < 2) {
                double opacity = this.maxOpaque_ * (1.0 - minCos / this.cosBrightAngle_);
                if (opacity < 0.0) {
                    opacity = 0.0;
                } else if (opacity > this.maxOpaque_) {
                    opacity = this.maxOpaque_;
                }
                g2d.setColor(new Color(0.0f, 0.0f, 0.0f, (float)opacity));
                g2d.fillRect(left, top, width, height);
            } else if (width < height) {
                int yAve = (top + bottom) / 2;
                this.drawDarkness(g2d, left, right, top, yAve);
                this.drawDarkness(g2d, left, right, yAve, bottom);
            } else {
                int xAve = (left + right) / 2;
                this.drawDarkness(g2d, left, xAve, top, bottom);
                this.drawDarkness(g2d, xAve, right, top, bottom);
            }
        }
    }
}

