/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.img;

import com.jhlabs.image.QuantizeFilter;
import gov.nasa.giss.img.ImageUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GifWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private BufferedImage image_;

    public GifWriter() {
    }

    public GifWriter(BufferedImage img) {
        this.setImage(img);
    }

    public void flush() {
        this.image_ = null;
    }

    public void setImage(BufferedImage img) {
        this.image_ = img;
    }

    public void write(File f) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(f);){
            this.write(fos);
        }
    }

    private void write(FileOutputStream ostream) throws IOException {
        Objects.requireNonNull(ostream, "Outputsteam cannot be null");
        try {
            ImageIO.write((RenderedImage)this.image_, "gif", ostream);
            return;
        }
        catch (IOException ignore) {
            LOGGER.debug("Exception trying to write GIF, probably due to color count > 256.");
            LOGGER.debug("We'll try a quantize filter and then try ImageIO again");
            try {
                int iw = this.image_.getWidth();
                int ih = this.image_.getHeight();
                int[] srcPixels = ImageUtils.getARGBPixels(this.image_);
                int[] dstPixels = new int[iw * ih];
                new QuantizeFilter().quantize(srcPixels, dstPixels, iw, ih, 256, false, true);
                BufferedImage bi = new BufferedImage(iw, ih, 1);
                WritableRaster bir = bi.getRaster();
                bir.setDataElements(0, 0, iw, ih, dstPixels);
                ImageIO.write((RenderedImage)bi, "gif", ostream);
            }
            catch (IOException ioe) {
                if (LOGGER.isTraceEnabled()) {
                    ioe.printStackTrace();
                }
                throw ioe;
            }
            return;
        }
    }
}

