/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.ps;

import gov.nasa.giss.graphics.ps.PsGraphics2D;
import gov.nasa.giss.graphics.ps.PsWriter;
import java.awt.Dimension;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PsDocument {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PsWriter writer_;
    private PsGraphics2D g2d_;
    private String title_;
    private int width_;
    private int height_;

    public PsDocument(Dimension size) {
        this(size.width, size.height);
    }

    public PsDocument(int width, int height) {
        this.width_ = width;
        this.height_ = height;
    }

    public Dimension getSize() {
        return new Dimension(this.width_, this.height_);
    }

    public PsGraphics2D createGraphics(boolean textAsCurves) {
        if (this.g2d_ != null) {
            return this.g2d_;
        }
        this.g2d_ = new PsGraphics2D(this, this.width_, this.height_, textAsCurves);
        return this.g2d_;
    }

    public void addWriter(PsWriter w) {
        this.writer_ = w;
    }

    public void open() {
        this.psPrintln("%!PS-Adobe-3.0 EPSF-3.0");
        this.psPrintln("%%Creator: GISSgfx PsDocument 1.0.1");
        if (this.title_ != null) {
            this.psPrintln("%%Title: " + this.title_);
        }
        this.psPrintln("%%CreationDate: " + new Date());
        this.psPrintln("%%BoundingBox: 0 0 " + this.width_ + " " + this.height_);
        this.psPrintln("%%DocumentData: Clean7Bit");
        this.psPrintln("%%DocumentProcessColors: Black");
        this.psPrintln("%%ColorUsage: Color");
        this.psPrintln("%%Origin: 0 0");
        this.psPrintln("%%Pages: 1");
        this.psPrintln("%%Page: 1 1");
        this.psPrintln("%%EndComments\n");
    }

    public void close() throws IOException {
        this.psPrintln("showpage");
        this.psPrintln("%%EOF");
        this.writer_.close();
    }

    protected void psPrint(String s) {
        Objects.requireNonNull(s, "String cannot be null");
        if (this.writer_ == null) {
            throw new RuntimeException("Writer is null");
        }
        try {
            this.writer_.write(s);
        }
        catch (IOException ioe) {
            LOGGER.error("{}", (Object)ioe.toString());
        }
    }

    protected void psPrintln(String s) {
        Objects.requireNonNull(s, "String cannot be null");
        if (this.writer_ == null) {
            throw new RuntimeException("Writer is null");
        }
        try {
            if (s == null) {
                this.writer_.write("\n");
            } else {
                this.writer_.write(s + "\n");
            }
        }
        catch (IOException ioe) {
            LOGGER.error("{}", (Object)ioe.toString());
        }
    }

    public void setTitle(String s) {
        this.title_ = s;
    }
}

