/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.plot;

import gov.nasa.giss.graphics.ColorUtils;
import gov.nasa.giss.graphics.GPrintable;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.graphics.plot.PlotHolder;
import gov.nasa.giss.graphics.plot.PlotPieceContainer;
import gov.nasa.giss.graphics.plot.PlotPieceMargins;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlotPiece
implements GPrintable,
ImageObserver,
PlotPieceContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private PlotPieceContainer parent_;
    private ArrayList<PlotPiece> children_;
    private PlotPieceMargins margins_ = new PlotPieceMargins();
    private Color background_ = Color.WHITE;
    private Color foreground_ = Color.BLACK;
    private int x_;
    private int y_;
    private int width_;
    private int height_;
    private boolean visible_ = true;
    private boolean opaque_ = true;
    private boolean noClip_;
    private Font font_;

    public PlotPiece() {
        this.setFont(new Font("SansSerif", 0, 9));
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x_, this.y_, this.width_, this.height_);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setLocation(x, y);
        this.setSize(width, height);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public Point getLocation() {
        return new Point(this.x_, this.y_);
    }

    public void setLocation(int x, int y) {
        this.x_ = x;
        this.y_ = y;
    }

    public int getWidth() {
        return this.width_;
    }

    public int getHeight() {
        return this.height_;
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.width_, this.height_);
    }

    public void setSize(int width, int height) {
        this.width_ = width;
        this.height_ = height;
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setMargins(int margin) {
        this.setMargins(margin, margin, margin, margin);
    }

    public void setMargins(int left, int top, int right, int bottom) {
        this.margins_.setMargins(left, top, right, bottom);
    }

    public PlotPieceMargins getMargins() {
        try {
            return (PlotPieceMargins)this.margins_.clone();
        }
        catch (Exception exc) {
            return null;
        }
    }

    public boolean isVisible() {
        return this.visible_;
    }

    public void setVisible(boolean vis) {
        this.visible_ = vis;
    }

    public boolean isOpaque() {
        return this.opaque_;
    }

    public void setOpaque(boolean opaque) {
        this.opaque_ = opaque;
    }

    public boolean isClippingDisabled() {
        return this.noClip_;
    }

    public void setClippingDisabled(boolean noclip) {
        this.noClip_ = noclip;
    }

    @Override
    public Color getBackground() {
        if (this.background_ == null) {
            return this.getParent().getBackground();
        }
        return this.background_;
    }

    public void setBackground(Color c) {
        this.background_ = c;
        if (c != null) {
            this.foreground_ = ColorUtils.getXORColor(c);
        }
    }

    @Override
    public Color getForeground() {
        return this.foreground_;
    }

    protected void setForeground(Color c) {
        this.foreground_ = c;
    }

    @Override
    public Font getFont() {
        return this.font_;
    }

    public void setFont(Font font) {
        this.font_ = font;
    }

    public PlotPieceContainer getParent() {
        return this.parent_;
    }

    protected ArrayList<PlotPiece> getChildren() {
        return this.children_;
    }

    public void setParent(PlotPieceContainer parent) {
        this.parent_ = parent;
    }

    @Override
    public void attach(PlotPiece piece) {
        Objects.requireNonNull("PlotPiece cannot be null");
        PlotPieceContainer oldParent = piece.getParent();
        if (oldParent != null) {
            oldParent.detach(piece);
        }
        if (this.children_ == null) {
            this.children_ = new ArrayList(10);
        }
        this.children_.add(piece);
        piece.setParent(this);
    }

    @Override
    public boolean detach(PlotPiece piece) {
        PlotPieceContainer oldParent = piece.getParent();
        if (oldParent == null || oldParent != this) {
            return false;
        }
        if (this.children_.indexOf(piece) > -1) {
            this.children_.remove(piece);
            piece.setParent(null);
            return true;
        }
        return false;
    }

    public boolean isPlotRoot() {
        if (this.parent_ == null) {
            return true;
        }
        return this.parent_ instanceof PlotHolder;
    }

    public PlotPiece getPlotRoot() {
        if (this.parent_ == null || this.parent_ instanceof PlotHolder) {
            return this;
        }
        return ((PlotPiece)this.parent_).getPlotRoot();
    }

    public PlotHolder getPlotHolder() {
        if (this.parent_ == null) {
            return null;
        }
        if (this.parent_ instanceof PlotHolder) {
            return (PlotHolder)this.parent_;
        }
        return ((PlotPiece)this.parent_).getPlotHolder();
    }

    @Override
    public void paint(Graphics2D g2d) {
        if (!this.visible_) {
            return;
        }
        this.paint(g2d, false);
    }

    @Override
    public void paint(BufferedImage img) {
        Graphics2D g2d = img.createGraphics();
        GraphicUtils.antialias(g2d);
        g2d.setClip(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        this.paint(g2d, true);
        g2d.dispose();
    }

    @Override
    public void print(Graphics2D g2d) {
        if (!this.visible_) {
            return;
        }
        this.paint(g2d, true);
    }

    protected void paint(Graphics2D g2d, boolean printing) {
        this.prepareToPaint();
        Rectangle clip = g2d.getClipBounds();
        if (clip == null) {
            LOGGER.warn("Null clip rect for plot piece.");
            LOGGER.warn("Did you create a graphics object but forget to set its clip?");
        }
        Rectangle rr = this.getBounds();
        if (rr.width == 0 || rr.height == 0) {
            return;
        }
        this.paintBackground(g2d, printing);
        this.paintPiece(g2d, printing);
        this.paintChildren(g2d, printing);
    }

    protected void prepareToPaint() {
    }

    protected void paintBackground(Graphics2D g2d, boolean printing) {
        if (this.opaque_) {
            int w = this.width_ - this.margins_.getLeft() - this.margins_.getRight();
            int h = this.height_ - this.margins_.getTop() - this.margins_.getBottom();
            g2d.setColor(this.background_);
            GraphicUtils.fillRect(g2d, this.margins_.getLeft(), this.margins_.getTop(), w, h);
        }
    }

    protected void paintPiece(Graphics2D g2d, boolean printing) {
    }

    protected void paintChildren(Graphics2D g2d, boolean printing) {
        if (this.children_ == null) {
            return;
        }
        Rectangle clip = g2d.getClipBounds();
        if (clip == null) {
            LOGGER.warn("Null clip rect for plot piece.");
            LOGGER.warn("Will not be able to set a clipping region when instructing child pieces to paint themselves.");
        }
        for (PlotPiece child : this.children_) {
            if (!child.isVisible()) continue;
            Rectangle rr = child.getBounds();
            if (rr.width == 0 || rr.height == 0) continue;
            if (clip != null) {
                if (rr.x > clip.x + clip.width || rr.x + rr.width < clip.x || rr.y > clip.y + clip.height || rr.y + rr.height < clip.y) continue;
                if (!child.isClippingDisabled()) {
                    Rectangle ri = clip.intersection(rr);
                    if (ri.width == 0 || ri.height == 0) continue;
                    g2d.setClip(ri);
                }
            }
            g2d.translate(rr.x, rr.y);
            child.paint(g2d, printing);
            g2d.translate(-rr.x, -rr.y);
            g2d.setClip(clip);
        }
    }

    @Override
    public BufferedImage getImage() {
        LOGGER.trace("w {}, h {}", (Object)this.getWidth(), (Object)this.getHeight());
        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        this.paint(img);
        return img;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }
}

