/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.clut;

import gov.nasa.giss.graphics.AbstractColorTable;
import gov.nasa.giss.graphics.clut.BinaryColorTable;
import java.awt.Color;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;

public class Pal1ColorTable
extends BinaryColorTable {
    public Pal1ColorTable() {
        this.initiateFixedSizeArray(254);
        for (int i = 0; i < 254; ++i) {
            float bright = (float)i / 253.0f;
            this.setColorAt(i, new Color(bright, bright, bright));
        }
        this.setMinOutlierColor(Color.BLUE);
        this.setMaxOutlierColor(Color.RED);
        this.setName("untitled");
        this.setType("PA1");
    }

    public Pal1ColorTable(File f) throws FileNotFoundException, IOException {
        super(f, 768, 768);
    }

    public Pal1ColorTable(URL url) throws IOException {
        super(url, 768, 768);
    }

    public Pal1ColorTable(byte[] b) throws IOException {
        super(b);
        this.setName("untitled");
        this.setType("PA1");
    }

    @Override
    public AbstractColorTable copy() throws IOException {
        Pal1ColorTable c = new Pal1ColorTable(this.getBytes());
        c.setName("Copy of " + this.getName());
        return c;
    }

    @Override
    public byte[] getBytes() {
        byte[] b = new byte[768];
        b[0] = (byte)this.getMinOutlierColor().getRed();
        b[256] = (byte)this.getMinOutlierColor().getGreen();
        b[512] = (byte)this.getMinOutlierColor().getBlue();
        b[255] = (byte)this.getMaxOutlierColor().getRed();
        b[511] = (byte)this.getMaxOutlierColor().getGreen();
        b[767] = (byte)this.getMaxOutlierColor().getBlue();
        for (int i = 0; i < 254; ++i) {
            Color c = this.getColorAt(i);
            b[1 + i] = (byte)c.getRed();
            b[257 + i] = (byte)c.getGreen();
            b[513 + i] = (byte)c.getBlue();
        }
        return b;
    }

    @Override
    protected void fillColorTable(byte[] b) throws EOFException {
        if (b.length < 768) {
            throw new EOFException("Not a valid PAL-1 color table");
        }
        this.initiateFixedSizeArray(254);
        for (int i = 0; i < 254; ++i) {
            this.setColorAt(i, new Color(0xFF & b[i + 1], 0xFF & b[i + 256 + 1], 0xFF & b[i + 512 + 1]));
        }
        this.setMinOutlierColor(new Color(0xFF & b[0], 0xFF & b[256], 0xFF & b[512]));
        this.setMaxOutlierColor(new Color(0xFF & b[255], 0xFF & b[511], 0xFF & b[767]));
    }
}

