/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics.clut;

import gov.nasa.giss.graphics.AbstractColorTable;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.text.ParseException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GimpGradient
extends AbstractColorTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int FAUX_BINS = 800;
    private static final double HALF_PI = 1.5707963267948966;

    public GimpGradient() {
        this(100);
    }

    public GimpGradient(int count) {
        this.initiateFixedSizeArray(count);
        for (int i = 0; i < count; ++i) {
            float bright = (float)i / (float)(count - 1);
            this.setColorAt(i, new Color(bright, bright, bright));
        }
        this.setName("untitled");
        this.setType("GGR");
    }

    public GimpGradient(File f) throws FileNotFoundException, IOException, ParseException {
        Objects.requireNonNull(f, "File cannot be null.");
        if (!f.exists()) {
            throw new FileNotFoundException("File does not exist.");
        }
        this.setURL(f.toURI().toURL());
        try (FileReader fr = new FileReader(f);
             BufferedReader br = new BufferedReader(fr);){
            this.parseColorTable(br);
        }
    }

    public GimpGradient(URL url) throws IOException, ParseException {
        Objects.requireNonNull(url, "URL cannot be null.");
        this.setURL(url);
        try (InputStream is = url.openStream();
             BufferedInputStream bis = new BufferedInputStream(is);
             InputStreamReader isr = new InputStreamReader(bis);
             BufferedReader br = new BufferedReader(isr);){
            this.parseColorTable(br);
        }
    }

    @Override
    public AbstractColorTable copy() throws IOException {
        GimpGradient c = new GimpGradient(256);
        c.setName("Copy of " + this.getName());
        return c;
    }

    private void parseColorTable(BufferedReader bReader) throws IOException, ParseException {
        int ibin;
        String oneLine = bReader.readLine();
        oneLine = oneLine.replaceFirst("^\\s+", "");
        if (!(oneLine = oneLine.replaceFirst("\\s+$", "")).equals("GIMP Gradient")) {
            throw new ParseException("Apparently not a GGR GIMP Gradient", 1);
        }
        oneLine = bReader.readLine();
        oneLine = bReader.readLine();
        oneLine = oneLine.replaceFirst("^\\s+", "");
        oneLine = oneLine.replaceFirst("\\s+$", "");
        int numSegs = Integer.parseInt(oneLine);
        double[][] rdata = new double[numSegs][3];
        Color[][] cdata = new Color[numSegs][2];
        int[] bdata = new int[numSegs];
        int[] mdata = new int[numSegs];
        for (int iseg = 0; iseg < numSegs; ++iseg) {
            oneLine = bReader.readLine();
            int comment = Math.min(oneLine.indexOf(59), oneLine.indexOf(35));
            if (comment > 0) {
                oneLine = oneLine.substring(0, comment - 1);
            }
            oneLine = oneLine.replaceFirst("^\\s+", "");
            String[] tokens = (oneLine = oneLine.replaceFirst("\\s+$", "")).split("\\s+");
            if (tokens.length < 13) {
                throw new ParseException("Bad token count " + tokens.length, iseg + 3);
            }
            try {
                rdata[iseg][0] = Double.parseDouble(tokens[0]);
                rdata[iseg][1] = Double.parseDouble(tokens[1]);
                rdata[iseg][2] = Double.parseDouble(tokens[2]);
                cdata[iseg][0] = this.getRGBColor(tokens[3], tokens[4], tokens[5]);
                cdata[iseg][1] = this.getRGBColor(tokens[7], tokens[8], tokens[9]);
                bdata[iseg] = Integer.parseInt(tokens[11]);
                mdata[iseg] = Integer.parseInt(tokens[12]);
                continue;
            }
            catch (Exception exc) {
                LOGGER.warn("Exception parsing GGR file at {}", (Object)(iseg + 3));
                if (LOGGER.isDebugEnabled()) {
                    exc.printStackTrace();
                }
                throw new ParseException("Exception parsing GGR file", iseg + 3);
            }
        }
        this.initiateFixedSizeArray(800);
        double rmin = rdata[0][0];
        double rmax = rdata[numSegs - 1][1];
        this.setRangeMinimum(rmin);
        this.setRangeMaximum(rmax);
        double range = rmax - rmin;
        double delta = range / 800.0;
        int lastSeg = 0;
        block3: for (ibin = 0; ibin < 800; ++ibin) {
            double val = rmin + delta * (0.5 + (double)ibin);
            for (int iseg = lastSeg; iseg < numSegs; ++iseg) {
                if (val < rdata[iseg][0] || val >= rdata[iseg][2]) continue;
                Color cleft = cdata[iseg][0];
                Color cright = cdata[iseg][1];
                double pct = val < rdata[iseg][1] ? 0.5 * (val - rdata[iseg][0]) / (rdata[iseg][1] - rdata[iseg][0]) : 0.5 + 0.5 * (val - rdata[iseg][1]) / (rdata[iseg][2] - rdata[iseg][1]);
                Color c = this.interpolate(cleft, cright, pct, mdata[iseg]);
                this.setColorAt(ibin, c);
                lastSeg = iseg;
                continue block3;
            }
        }
        for (ibin = 0; ibin < 800; ++ibin) {
            if (this.getColorAt(ibin) != null) continue;
            this.setColorAt(ibin, UNDEFINED_COLOR);
        }
    }

    private Color interpolate(Color c1, Color c2, double pct, int how) {
        if (c1.equals(c2) && how == 0) {
            return c1;
        }
        double pctX = pct;
        switch (how) {
            case 2: {
                pctX = 0.5 * (1.0 + Math.cos(2.0 * (pct + 1.0) * 1.5707963267948966));
                break;
            }
            case 3: {
                pctX = Math.sin(pct * 1.5707963267948966);
                break;
            }
            case 4: {
                pctX = 1.0 - Math.cos(pct * 1.5707963267948966);
                break;
            }
            default: {
                pctX = pct;
            }
        }
        int r1 = c1.getRed();
        int r2 = c2.getRed();
        int g1 = c1.getGreen();
        int g2 = c2.getGreen();
        int b1 = c1.getBlue();
        int b2 = c2.getBlue();
        if (how == 0) {
            int r = (int)((double)r1 + pctX * (double)(r2 - r1));
            int g = (int)((double)g1 + pctX * (double)(g2 - g1));
            int b = (int)((double)b1 + pctX * (double)(b2 - b1));
            return new Color(r, g, b);
        }
        float[] hsv1 = Color.RGBtoHSB(r1, g1, b1, null);
        float[] hsv2 = Color.RGBtoHSB(r2, g2, b2, null);
        if (how == 2 && hsv2[0] < hsv1[0]) {
            hsv2[0] = hsv2[0] + 1.0f;
        }
        if (how == 1 && hsv2[0] > hsv1[0]) {
            hsv1[0] = hsv1[0] + 1.0f;
        }
        float h = hsv1[0] + (float)pctX * (hsv2[0] - hsv1[0]);
        float s = hsv1[1] + (float)pctX * (hsv2[1] - hsv1[1]);
        float v = hsv1[2] + (float)pctX * (hsv2[2] - hsv1[2]);
        return Color.getHSBColor(h, s, v);
    }

    private Color getRGBColor(String r, String g, String b) {
        float r1 = Float.parseFloat(r);
        if (r1 < 0.0f || r1 > 1.0f) {
            throw new IllegalArgumentException("R value outside valid range");
        }
        float g1 = Float.parseFloat(g);
        if (g1 < 0.0f || g1 > 1.0f) {
            throw new IllegalArgumentException("G value outside valid range");
        }
        float b1 = Float.parseFloat(b);
        if (b1 < 0.0f || b1 > 1.0f) {
            throw new IllegalArgumentException("B value out outside valid range");
        }
        return new Color(r1, g1, b1);
    }

    @Override
    public boolean saveAs(File f) throws IOException, FileNotFoundException {
        return false;
    }

    class HsvColor {
        final float h_;
        final float s_;
        final float v_;

        HsvColor(float h, float s, float v) {
            this.h_ = h;
            this.s_ = s;
            this.v_ = v;
        }

        float getH() {
            return this.h_;
        }

        float getS() {
            return this.s_;
        }

        float getV() {
            return this.v_;
        }

        Color toRGBColor() {
            return Color.getHSBColor(this.h_, this.s_, this.v_);
        }
    }
}

