/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import gov.nasa.giss.text.StringUtils;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.Arc2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.invoke.MethodHandles;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GraphicUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static void preInitializeGraphics() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Font f = new Font("SansSerif", 0, 12);
        FontMetrics fm = tk.getFontMetrics(f);
    }

    public static Graphics2D createAntialiasedGfx(Graphics g) {
        Objects.requireNonNull(g, "Graphics object cannot be null");
        Graphics2D g2d = (Graphics2D)g.create();
        GraphicUtils.antialias(g2d);
        return g2d;
    }

    public static void antialias(Graphics2D g2d) {
        Objects.requireNonNull(g2d, "Graphics object cannot be null");
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
    }

    public static void drawLine(Graphics2D g2d, double x1, double y1, double x2, double y2) {
        Objects.requireNonNull(g2d, "Graphics object cannot be null");
        Path2D.Double path = new Path2D.Double();
        path.moveTo(x1, y1);
        path.lineTo(x2, y2);
        g2d.draw(path);
    }

    public static void drawLine(Graphics2D g2d, Point2D p1, Point2D p2) {
        Objects.requireNonNull(p1, "Starting point cannot be null");
        Objects.requireNonNull(p2, "End point cannot be null");
        GraphicUtils.drawLine(g2d, p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static void drawRect(Graphics2D g2d, double x, double y, double w, double h) {
        Objects.requireNonNull(g2d, "Graphics object cannot be null");
        Rectangle2D.Double r = new Rectangle2D.Double(x, y, w, h);
        g2d.draw(r);
    }

    public static void fillRect(Graphics2D g2d, double x, double y, double w, double h) {
        Objects.requireNonNull(g2d, "Graphics object cannot be null");
        Rectangle2D.Double r = new Rectangle2D.Double(x, y, w, h);
        g2d.fill(r);
    }

    public static void fillAndDrawRect(Graphics2D g2d, float x, float y, float w, float h) {
        Objects.requireNonNull(g2d, "Graphics object cannot be null");
        Rectangle2D.Double r = new Rectangle2D.Double(x, y, w, h);
        g2d.fill(r);
        g2d.draw(r);
    }

    public static void drawCircularArc(Graphics2D g2d, double x1, double y1, double x2, double y2, double x3, double y3) {
        double a1;
        Objects.requireNonNull(g2d, "Graphics object cannot be null");
        if (x1 == x2 && y1 == y2) {
            throw new IllegalArgumentException("Coordinate pairs 1 and 2 are identical.");
        }
        if (x1 == x3 && y1 == y3) {
            throw new IllegalArgumentException("Coordinate pairs 1 and 3 are identical.");
        }
        if (x2 == x3 && y2 == y3) {
            throw new IllegalArgumentException("Coordinate pairs 2 and 3 are identical.");
        }
        if (Math.abs(x1 * (y2 - y3) + x2 * (y3 - y1) * x3 * (y1 - y2)) < 1.0E-9) {
            if (x2 > x1 && x2 > x3 || x2 < x1 && x2 < x3) {
                throw new IllegalArgumentException("Three coordinate points are on the same line, but not in order.");
            }
            GraphicUtils.drawLine(g2d, x1, y1, x3, y3);
            return;
        }
        double dd = 2.0 * (x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2));
        if (dd == 0.0) {
            return;
        }
        double x0 = ((x1 * x1 + y1 * y1) * (y2 - y3) + (x2 * x2 + y2 * y2) * (y3 - y1) + (x3 * x3 + y3 * y3) * (y1 - y2)) / dd;
        double y0 = ((x1 * x1 + y1 * y1) * (x3 - x2) + (x2 * x2 + y2 * y2) * (x1 - x3) + (x3 * x3 + y3 * y3) * (x2 - x1)) / dd;
        double dx1 = x1 - x0;
        double dy1 = y1 - y0;
        double dx2 = x2 - x0;
        double dy2 = y2 - y0;
        double dx3 = x3 - x0;
        double dy3 = y3 - y0;
        double rr = Math.sqrt(dx1 * dx1 + dy1 * dy1);
        double a2 = Math.toDegrees(Math.atan2(-dy2, dx2));
        double a3 = Math.toDegrees(Math.atan2(-dy3, dx3));
        for (a1 = Math.toDegrees(Math.atan2(-dy1, dx1)); a1 < 0.0; a1 += 360.0) {
        }
        while (a2 < 0.0) {
            a2 += 360.0;
        }
        while (a3 < 0.0) {
            a3 += 360.0;
        }
        while (a2 < a1) {
            a2 += 360.0;
        }
        while (a3 < a1) {
            a3 += 360.0;
        }
        double aa = 0.0;
        aa = a3 > a2 ? a3 - a1 : a3 - a1 - 360.0;
        Arc2D.Double arc = new Arc2D.Double();
        arc.setArcByCenter(x0, y0, rr, a1, aa, 0);
        g2d.draw(arc);
    }

    public static void drawCircularArc(Graphics2D g2d, Point2D p1, Point2D p2, Point2D p3) {
        Objects.requireNonNull(p1, "Starting point cannot be null");
        Objects.requireNonNull(p2, "Mid point cannot be null");
        Objects.requireNonNull(p3, "End point cannot be null");
        GraphicUtils.drawCircularArc(g2d, p1.getX(), p1.getY(), p2.getX(), p2.getY(), p3.getX(), p3.getY());
    }

    public static float stringWidth(Object str, Graphics2D g2d) {
        Objects.requireNonNull(str, "String object cannot be null");
        if (str instanceof String) {
            FontMetrics fm = g2d.getFontMetrics();
            return fm.stringWidth((String)str);
        }
        if (str instanceof AttributedString) {
            return GraphicUtils.attributedStringWidth((AttributedString)str, g2d);
        }
        throw new IllegalArgumentException("Object not a String or AttributedString - " + str.getClass());
    }

    public static float attributedStringWidth(AttributedString astr, Graphics2D g2d) {
        Objects.requireNonNull(astr, "AttributedString object cannot be null");
        AttributedCharacterIterator aci = astr.getIterator();
        if (aci.getEndIndex() == 0) {
            return 0.0f;
        }
        TextLayout tl = new TextLayout(aci, g2d.getFontRenderContext());
        Rectangle2D.Float bounds = (Rectangle2D.Float)tl.getBounds();
        return bounds.width;
    }

    public static Object trimStringToFit(Object str, Graphics2D g2d, int maxlength) {
        Objects.requireNonNull(str, "String object cannot be null");
        if (str instanceof String) {
            return GraphicUtils.trimStringToFit((String)str, g2d, maxlength);
        }
        if (str instanceof AttributedString) {
            return GraphicUtils.trimStringToFit((AttributedString)str, g2d, maxlength);
        }
        throw new IllegalArgumentException("Object not a String or AttributedString - " + str.getClass());
    }

    public static String trimStringToFit(String str, Graphics2D g2d, int maxlength) {
        if (maxlength <= 0 || str == null || g2d == null) {
            return str;
        }
        if (str.length() < 3) {
            return str;
        }
        FontMetrics fm = g2d.getFontMetrics();
        Object result = str;
        while (fm.stringWidth((String)result) > maxlength) {
            if (((String)result).length() < 2) {
                return result;
            }
            int olength = ((String)result).length();
            result = ((String)result).substring(0, olength - 2) + "\u2026";
        }
        return result;
    }

    public static AttributedString trimStringToFit(AttributedString astr, Graphics2D g2d, int maxlength) {
        if (maxlength <= 0 || astr == null || g2d == null) {
            return astr;
        }
        if (StringUtils.length(astr) < 3) {
            return astr;
        }
        AttributedCharacterIterator aci = astr.getIterator();
        if (aci.getEndIndex() == 0) {
            return astr;
        }
        AttributedString result = astr;
        int useChars = StringUtils.length(astr) - 1;
        while (GraphicUtils.attributedStringWidth(result, g2d) > (float)maxlength) {
            Map<AttributedCharacterIterator.Attribute, Object> attrs;
            --useChars;
            StringBuilder sb = new StringBuilder(50);
            int ii = 0;
            char c = aci.first();
            while (c != '\uffff') {
                sb.append(c);
                if (++ii > useChars) break;
                c = aci.next();
            }
            sb.append("\u2026");
            result = new AttributedString(sb.toString());
            ii = 0;
            c = aci.first();
            while (c != '\uffff') {
                attrs = aci.getAttributes();
                result.addAttributes(attrs, ii, ii + 1);
                if (++ii > useChars) break;
                c = aci.next();
            }
            c = aci.first();
            attrs = aci.getAttributes();
            result.addAttributes(attrs, ii, ii + 1);
        }
        return result;
    }

    public static void drawString(Graphics2D g2d, Object str, int x, int y) {
        Objects.requireNonNull(str, "What? You want me to paint a null string?");
        if (str instanceof String) {
            g2d.drawString((String)str, x, y);
        } else if (str instanceof AttributedString) {
            GraphicUtils.drawAttributedString((AttributedString)str, g2d, x, y);
        } else {
            throw new IllegalArgumentException("Unknown 'string' class " + str.getClass());
        }
    }

    public static void drawString(Graphics2D g2d, Object str, float x, float y) {
        Objects.requireNonNull(str, "What? You want me to paint a null string?");
        if (str instanceof String) {
            g2d.drawString((String)str, x, y);
        } else if (str instanceof AttributedString) {
            GraphicUtils.drawAttributedString((AttributedString)str, g2d, x, y);
        } else {
            throw new IllegalArgumentException("Unknown 'string' class " + str.getClass());
        }
    }

    public static void drawAttributedString(AttributedString astr, Graphics2D g2d, float x, float y) {
        Objects.requireNonNull(astr, "What? You want me to render a null string?");
        AttributedCharacterIterator aci = astr.getIterator();
        g2d.drawString(aci, x, y);
    }

    public static void drawStringAsGlyph(String str, Graphics2D g2d, float x, float y) {
        Objects.requireNonNull(str, "What? You want me to render a null string?");
        Objects.requireNonNull(g2d, "Graphics object cannot be null");
        if (str.isEmpty()) {
            return;
        }
        GlyphVector gv = g2d.getFont().createGlyphVector(g2d.getFontRenderContext(), str.toCharArray());
        g2d.drawGlyphVector(gv, x, y);
    }

    public static BasicStroke buttMiterStroke(float weight) {
        if (weight < 0.0f) {
            throw new IllegalArgumentException("Line weight cannot be negative");
        }
        return new BasicStroke(0.01f * weight, 0, 0);
    }

    public static BasicStroke buttMiterStroke(float weight, float[] pattern) {
        if (weight < 0.0f) {
            throw new IllegalArgumentException("Line weight cannot be negative");
        }
        if (pattern == null) {
            return GraphicUtils.buttMiterStroke(weight);
        }
        float offset = 0.33f * pattern[0];
        return new BasicStroke(0.01f * weight, 0, 0, 1.0f, pattern, offset);
    }

    public static BasicStroke buttMiterStroke(float weight, float[] pattern, float offset) {
        if (weight < 0.0f) {
            throw new IllegalArgumentException("Line weight cannot be negative");
        }
        if (pattern == null) {
            return GraphicUtils.buttMiterStroke(weight);
        }
        return new BasicStroke(0.01f * weight, 0, 0, 1.0f, pattern, offset);
    }

    public static BasicStroke squareMiterStroke(float weight) {
        if (weight < 0.0f) {
            throw new IllegalArgumentException("Line weight cannot be negative");
        }
        return new BasicStroke(0.01f * weight, 2, 0);
    }

    public static BasicStroke squareMiterStroke(float weight, float[] pattern) {
        if (weight < 0.0f) {
            throw new IllegalArgumentException("Line weight cannot be negative");
        }
        if (pattern == null) {
            return GraphicUtils.squareMiterStroke(weight);
        }
        float offset = 0.33f * pattern[0];
        return new BasicStroke(0.01f * weight, 2, 0, 1.0f, pattern, offset);
    }

    public static BasicStroke squareMiterStroke(float weight, float[] pattern, float offset) {
        if (weight < 0.0f) {
            throw new IllegalArgumentException("Line weight cannot be negative");
        }
        if (pattern == null) {
            return GraphicUtils.squareMiterStroke(weight);
        }
        return new BasicStroke(0.01f * weight, 2, 0, 1.0f, pattern, offset);
    }

    public static BasicStroke roundStroke(float weight) {
        if (weight < 0.0f) {
            throw new IllegalArgumentException("Line weight cannot be negative");
        }
        return new BasicStroke(0.01f * weight, 1, 1);
    }

    public static BasicStroke roundStroke(float weight, float[] pattern) {
        if (weight < 0.0f) {
            throw new IllegalArgumentException("Line weight cannot be negative");
        }
        if (pattern == null) {
            return GraphicUtils.roundStroke(weight);
        }
        float offset = 0.33f * pattern[0];
        return new BasicStroke(0.01f * weight, 1, 1, 1.0f, pattern, offset);
    }

    private GraphicUtils() {
    }
}

