/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import java.awt.Color;
import java.lang.invoke.MethodHandles;
import java.text.ParseException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColorUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static Color getXORColor(Color c) {
        return new Color(c.getRGB() ^ 0xFFFFFF);
    }

    public static String colorToString(Color c) {
        StringBuilder sb = new StringBuilder("");
        if (c.getAlpha() < 255) {
            sb.append("rgba(");
        } else {
            sb.append("rgb(");
        }
        sb.append(c.getRed()).append(',').append(c.getGreen()).append(',').append(c.getBlue());
        if (c.getAlpha() < 255) {
            sb.append(',').append(c.getAlpha());
        }
        sb.append(')');
        String result = sb.toString();
        if (result.equalsIgnoreCase("rgb(0,0,0)")) {
            return "black";
        }
        if (result.equalsIgnoreCase("rgb(255,255,255)")) {
            return "white";
        }
        if (result.equalsIgnoreCase("rgb(255,0,0)")) {
            return "red";
        }
        return result;
    }

    public static String colorToHexString(Color c) {
        Object rstr = Integer.toHexString(c.getRed());
        Object gstr = Integer.toHexString(c.getGreen());
        Object bstr = Integer.toHexString(c.getBlue());
        if (((String)rstr).length() < 2) {
            rstr = "0" + (String)rstr;
        }
        if (((String)gstr).length() < 2) {
            gstr = "0" + (String)rstr;
        }
        if (((String)bstr).length() < 2) {
            bstr = "0" + (String)rstr;
        }
        StringBuilder sb = new StringBuilder("#").append((String)rstr).append((String)gstr).append((String)bstr);
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Color parseColor(String s) throws ParseException {
        String slc;
        Objects.requireNonNull(s, "Color string cannot be null.");
        if (s.startsWith("java.awt.Color[")) {
            block73: {
                try {
                    s = s.replaceFirst(".*\\[", "");
                    s = s.replaceFirst("\\].*", "");
                }
                catch (Exception exc) {
                    if (!LOGGER.isDebugEnabled()) break block73;
                    exc.printStackTrace();
                }
            }
            try {
                String[] rgbx = s.split(",");
                if (rgbx.length < 3) {
                    return null;
                }
                int[] rgb = new int[3];
                for (int i = 0; i < 3; ++i) {
                    rgbx[i] = rgbx[i].replaceAll("\\D", "");
                    rgb[i] = Integer.parseInt(rgbx[i]);
                    rgb[i] = Math.max(rgb[i], 0);
                    rgb[i] = Math.min(rgb[i], 255);
                }
                return new Color(rgb[0], rgb[1], rgb[2]);
            }
            catch (Exception exc) {
                if (!LOGGER.isDebugEnabled()) throw new ParseException("Unrecognized color name string", 0);
                exc.printStackTrace();
                throw new ParseException("Unrecognized color name string", 0);
            }
        }
        if (s.startsWith("rgb(") && s.indexOf(37) > -1) {
            block74: {
                try {
                    s = s.replaceFirst(".*\\(", "");
                    s = s.replaceFirst("\\).*", "");
                }
                catch (Exception exc) {
                    if (!LOGGER.isDebugEnabled()) break block74;
                    exc.printStackTrace();
                }
            }
            try {
                String[] rgbx = s.split(",");
                if (rgbx.length < 3) {
                    return null;
                }
                float[] rgb = new float[3];
                for (int i = 0; i < 3; ++i) {
                    rgbx[i] = rgbx[i].replaceAll("\\%", "");
                    rgbx[i] = rgbx[i].replaceAll("\\D", "");
                    rgb[i] = Float.parseFloat(rgbx[i]);
                    rgb[i] = Math.max(rgb[i], 0.0f);
                    rgb[i] = Math.min(rgb[i], 255.0f);
                }
                return new Color(rgb[0], rgb[1], rgb[2]);
            }
            catch (Exception rgbx) {
                throw new ParseException("Unrecognized color name string", 0);
            }
        }
        if (s.startsWith("rgb(") || s.startsWith("rgba(")) {
            block75: {
                try {
                    s = s.replaceFirst(".*\\(", "");
                    s = s.replaceFirst("\\).*", "");
                }
                catch (Exception exc) {
                    if (!LOGGER.isDebugEnabled()) break block75;
                    exc.printStackTrace();
                }
            }
            try {
                String[] rgbx = s.split(",");
                if (rgbx.length < 3) {
                    return null;
                }
                int[] rgb = new int[rgbx.length];
                for (int i = 0; i < rgbx.length; ++i) {
                    rgbx[i] = rgbx[i].replaceAll("\\D", "");
                    rgb[i] = Integer.parseInt(rgbx[i]);
                    rgb[i] = Math.max(rgb[i], 0);
                    rgb[i] = Math.min(rgb[i], 255);
                }
                if (rgb.length != 4) return new Color(rgb[0], rgb[1], rgb[2]);
                return new Color(rgb[0], rgb[1], rgb[2], rgb[3]);
            }
            catch (Exception rgbx) {
                throw new ParseException("Unrecognized color name string", 0);
            }
        }
        if (s.charAt(0) == '#') {
            if ((s = s.substring(1)).length() == 3) {
                char c1 = s.charAt(0);
                char c2 = s.charAt(1);
                char c3 = s.charAt(2);
                return Color.decode("0x" + c1 + c1 + c2 + c2 + c3 + c3);
            }
            if (s.length() != 6) return Color.decode("0x" + s);
            return Color.decode("0x" + s);
        }
        switch (slc = s.toLowerCase()) {
            case "black": {
                return Color.BLACK;
            }
            case "silver": {
                return Color.LIGHT_GRAY;
            }
            case "gray": {
                return Color.GRAY;
            }
            case "white": {
                return Color.WHITE;
            }
            case "maroon": {
                return Color.decode("0x800000");
            }
            case "red": {
                return Color.RED;
            }
            case "purple": {
                return Color.decode("0x800080");
            }
            case "fuchsia": {
                return Color.MAGENTA;
            }
            case "green": {
                return Color.decode("0x008000");
            }
            case "lime": {
                return Color.GREEN;
            }
            case "olive": {
                return Color.decode("0x808000");
            }
            case "yellow": {
                return Color.YELLOW;
            }
            case "navy": {
                return Color.decode("0x000080");
            }
            case "blue": {
                return Color.BLUE;
            }
            case "teal": {
                return Color.decode("0x008080");
            }
            case "aqua": {
                return Color.decode("0x00ffff");
            }
            case "cyan": {
                return Color.CYAN;
            }
            case "darkgray": 
            case "dark_gray": {
                return Color.DARK_GRAY;
            }
            case "lightgray": 
            case "light_gray": {
                return Color.LIGHT_GRAY;
            }
            case "magenta": {
                return Color.MAGENTA;
            }
            case "orange": {
                return Color.ORANGE;
            }
            case "pink": {
                return Color.PINK;
            }
        }
        throw new ParseException("Unrecognized color name string", 0);
    }

    private ColorUtils() {
    }
}

