/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.graphics;

import java.awt.color.ColorSpace;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmykColorSpace
extends ColorSpace {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public CmykColorSpace() {
        super(9, 4);
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        ColorSpace cspace = ColorSpace.getInstance(1004);
        float[] rgb = cspace.toCIEXYZ(colorvalue);
        return this.fromRGB(rgb);
    }

    @Override
    public float[] fromRGB(float[] rgb) {
        Objects.requireNonNull("Components cannot be null");
        if (rgb.length != 3) {
            throw new IllegalArgumentException("Three components required.");
        }
        float w = Math.max(rgb[0], Math.max(rgb[1], rgb[2]));
        if ((double)w > 1.0) {
            LOGGER.warn("!!! {}, {}, {}", Float.valueOf(rgb[0]), Float.valueOf(rgb[1]), Float.valueOf(rgb[2]));
        }
        float k = 1.0f - w;
        float cc = w - rgb[0];
        float mc = w - rgb[1];
        float yc = w - rgb[2];
        if (w == 0.0f) {
            return new float[]{cc, mc, yc, 1.0f};
        }
        float c = cc / w;
        float m = mc / w;
        float y = yc / w;
        return new float[]{c, m, y, k};
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        float[] rgb = this.toRGB(colorvalue);
        ColorSpace cspace = ColorSpace.getInstance(1004);
        return cspace.toCIEXYZ(rgb);
    }

    @Override
    public float[] toRGB(float[] cmyk) {
        Objects.requireNonNull("Components cannot be null");
        if (cmyk.length != 4) {
            throw new IllegalArgumentException("Four components required.");
        }
        if ((double)cmyk[0] > 1.0 || (double)cmyk[1] > 1.0 || (double)cmyk[2] > 1.0 || (double)cmyk[3] > 1.0) {
            LOGGER.warn("!!! {}, {}, {}, []", Float.valueOf(cmyk[0]), Float.valueOf(cmyk[1]), Float.valueOf(cmyk[2]), Float.valueOf(cmyk[3]));
        }
        float w = 1.0f - cmyk[3];
        float r = (1.0f - cmyk[0]) * w;
        float g = (1.0f - cmyk[1]) * w;
        float b = (1.0f - cmyk[2]) * w;
        return new float[]{r, g, b};
    }

    private float normalize(float value) {
        if (value > 1.0f) {
            return 1.0f;
        }
        if (value < 0.0f) {
            return 0.0f;
        }
        return value;
    }
}

