/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.ui;

import gov.nasa.giss.data.nc.NcCatalog;
import gov.nasa.giss.data.nc.NcCatalogList;
import gov.nasa.giss.data.nc.NcCatalogNode;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.ui.treetable.TreeTableModel;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcCatalogTreeTableModel
extends TreeTableModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String[] COLUMN_NAMES = new String[]{"Name"};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{TreeTableModel.class};

    public NcCatalogTreeTableModel() {
        super(new NcCatalogList());
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return COLUMN_CLASSES[col];
    }

    @Override
    public int getColumnAlignment(int col) {
        return 2;
    }

    @Override
    public Object getValueAt(TreeTableNode node, int col) {
        if (node == null) {
            return "";
        }
        NcCatalogNode o = (NcCatalogNode)node;
        try {
            switch (col) {
                case 0: {
                    return o.getName();
                }
                case 1: {
                    return o.getClass().toString();
                }
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void setValueAt(Object value, TreeTableNode node, int col) {
    }

    public NcCatalogNode addCatalog(URL url) throws MalformedURLException, URISyntaxException {
        NcCatalog child;
        URL url2;
        Object urlString;
        block15: {
            urlString = url.toString();
            LOGGER.trace("Base address {}", urlString);
            if (((String)urlString).endsWith("catalog.html")) {
                int index = ((String)urlString).lastIndexOf("catalog.html");
                urlString = ((String)urlString).substring(0, index) + "catalog.xml";
                url2 = new URL((String)urlString);
            } else if (((String)urlString).endsWith("/")) {
                urlString = (String)urlString + "catalog.xml";
                url2 = new URL((String)urlString);
            } else {
                url2 = url;
            }
            child = null;
            try {
                LOGGER.trace("1. Trying to load {}", (Object)url2);
                child = this.tryCatalogURL(url2);
            }
            catch (NcException nce) {
                throw nce;
            }
            catch (FileNotFoundException fnfe) {
                LOGGER.trace("File not found at that address.");
            }
            catch (Exception exc) {
                if (!LOGGER.isTraceEnabled()) break block15;
                exc.printStackTrace();
            }
        }
        if (child == null && !((String)urlString).endsWith("/catalog.xml")) {
            url2 = new URL((String)urlString + "/catalog.xml");
            try {
                LOGGER.trace("2. Trying to load {}", (Object)url2);
                child = this.tryCatalogURL(url2);
            }
            catch (NcException nce) {
                throw nce;
            }
            catch (FileNotFoundException fnfe) {
                throw new NcException("No file at that URL.");
            }
            catch (Exception exc) {
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                throw new NcException(exc.toString());
            }
        }
        if (child == null) {
            LOGGER.trace("No catalog found.", (Object)url2);
            throw new NcException("No catalog found.");
        }
        NcCatalogList root = (NcCatalogList)this.getRoot();
        root.add(child);
        int isize = root.getChildCount();
        this.nodeInserted(root, isize - 1, child);
        return child;
    }

    public NcCatalog tryCatalogURL(URL url) throws FileNotFoundException, IOException, URISyntaxException {
        URI uri = url.toURI();
        if (this.containsCatalogWithURI(uri)) {
            throw new NcException("Catalog is already open.");
        }
        return new NcCatalog(null, uri);
    }

    public void removeCatalog(NcCatalogNode child) {
        block4: {
            if (!(child instanceof NcCatalog)) {
                return;
            }
            NcCatalogList root = (NcCatalogList)this.getRoot();
            int index = root.getIndex(child);
            if (index < 0) {
                LOGGER.warn("Apparently trying to remove NcCatalogNode which is not child catalog list.");
                return;
            }
            try {
                root.remove(index);
                this.nodeRemoved(root, index, child);
            }
            catch (Exception exc) {
                LOGGER.error("{}", (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) break block4;
                exc.printStackTrace();
            }
        }
    }

    public boolean containsCatalogWithURI(URI uri) {
        NcCatalogList root = (NcCatalogList)this.getRoot();
        for (TreeTableNode child : root.getChildren()) {
            NcCatalog catalog = (NcCatalog)child;
            if (!uri.equals(catalog.getURI())) continue;
            return true;
        }
        return false;
    }
}

