/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcLLAltGridding;
import gov.nasa.giss.data.nc.NcLLAltGriddingVarType;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.geoloc.projection.UtmProjection;
import ucar.units.Converter;
import ucar.units.SI;
import ucar.units.ScaledUnit;
import ucar.units.Unit;

public class NcArrayLonLatUTM
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Projection njProj_;
    private Converter toProjUnits_;
    private Converter fromProjUnits_;

    public NcArrayLonLatUTM(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjection.UTM);
        this.initMe();
    }

    private void initMe() {
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcLLAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcLLAltGriddingVarType)vtype).isGrid(NcLLAltGridding.UTM)) {
            throw new NcException("Variable is not projected type UTM.");
        }
        VariableDS vds = (VariableDS)this.ncvar_.getObject();
        List csList = vds.getCoordinateSystems();
        if (csList.isEmpty()) {
            throw new NcException("No coordinate system(s) reported.");
        }
        CoordinateSystem cs = (CoordinateSystem)csList.get(0);
        Projection pj = cs.getProjection();
        if (pj == null || pj instanceof LatLonProjection) {
            pj = this.buildProjection();
        }
        if (pj == null) {
            throw new NcException("CS returned null projection handler.");
        }
        if (!(pj instanceof UtmProjection)) {
            throw new NcException("CS returned wrong proj - " + pj.getClass());
        }
        this.njProj_ = pj;
        CoordinateAxis xaxis = NcVarUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.GEOX);
        String xUnits = xaxis.getUnitsString();
        try {
            ScaledUnit projUnit = new ScaledUnit(1000.0, SI.METER);
            Unit eastUnit = NcUnitUtils.parse(xUnits);
            this.toProjUnits_ = eastUnit.getConverterTo(projUnit);
            this.fromProjUnits_ = projUnit.getConverterTo(eastUnit);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Projection buildProjection() {
        this.getGridMappingName();
        if (!this.mappingName_.equalsIgnoreCase("universal_transverse_mercator")) {
            throw new NcException("Grid mapping name is not UTM.");
        }
        Attribute zoneA = this.mappingVarDS_.findAttribute("utm_zone_number");
        if (zoneA == null) {
            throw new NcException("UTM zone attribute is missing.");
        }
        int zone = zoneA.getNumericValue().intValue();
        boolean isNorth = true;
        if (zone < 0) {
            zone = Math.abs(zone);
            isNorth = false;
        }
        UtmProjection upj = null;
        Attribute semiA = this.mappingVarDS_.findAttribute("semi_major_axis");
        Attribute invfA = this.mappingVarDS_.findAttribute("inverse_flattening");
        if (semiA == null && invfA == null) {
            upj = new UtmProjection(zone, isNorth);
        } else if (semiA == null || invfA == null) {
            LOGGER.warn("Axis or flattening attribute found, but not the other.");
            upj = new UtmProjection(zone, isNorth);
        } else {
            double semi = semiA.getNumericValue().doubleValue();
            double invf = invfA.getNumericValue().doubleValue();
            if (semi < 10000.0) {
                semi *= 1000.0;
            }
            upj = new UtmProjection(semi, invf, zone, isNorth);
        }
        return upj;
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        Point2D.Double xy = NcArrayLonLatUTM.transformNjLL2XY(this.njProj_, lon, lat);
        if (xy == null) {
            return null;
        }
        if (this.fromProjUnits_ != null) {
            xy.x = this.fromProjUnits_.convert(xy.x);
            xy.y = this.fromProjUnits_.convert(xy.y);
        }
        return xy;
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double xx = this.toProjUnits_ == null ? x : this.toProjUnits_.convert(x);
        double yy = this.toProjUnits_ == null ? y : this.toProjUnits_.convert(y);
        return NcArrayLonLatUTM.transformNjXY2LL(this.njProj_, xx, yy);
    }
}

