/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcLLAltGridding;
import gov.nasa.giss.data.nc.NcLLAltGriddingVarType;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.VariableDS;

public class NcArrayLonLatSinusoidal
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public NcArrayLonLatSinusoidal(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjection.SINUSOIDAL);
        this.initMe();
    }

    private void initMe() {
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcLLAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcLLAltGriddingVarType)vtype).isGrid(NcLLAltGridding.SINUSOIDAL)) {
            throw new NcException("Variable is not projected type sinusoidal.");
        }
        VariableDS vds = (VariableDS)this.ncvar_.getObject();
        List csList = vds.getCoordinateSystems();
        if (csList.isEmpty()) {
            throw new NcException("No coordinate system(s) reported.");
        }
        this.getGridMappingName();
        if (!this.mappingName_.equalsIgnoreCase("sinusoidal")) {
            LOGGER.trace("Found unusable mapping name {}", (Object)this.mappingName_);
            throw new NcException("Mapping name is not sinusoidal");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return null;
        }
        double lambdaRad = Math.toRadians(lon - this.lambdaC_);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double y = phiRad;
        double x = lambdaRad * cosPhi;
        return new Point2D.Double(x * this.radius_ + this.falseEasting_, y * this.radius_ + this.falseNorthing_);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double lambdaRad;
        double phiRad = (y - this.falseNorthing_) * this.oneOverR_;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double cosPhi = Math.cos(phiRad);
        double d = lambdaRad = cosPhi == 0.0 ? 0.0 : (x - this.falseEasting_) * this.oneOverR_ / cosPhi;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
    }
}

