/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcLLAltGridding;
import gov.nasa.giss.data.nc.NcLLAltGriddingVarType;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LambertAzimuthalEqualArea;

public class NcArrayLonLatAzimuthalEqualArea
extends NcArrayLonLatProjected {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final boolean USE_NJ_PROJ = false;
    private Projection njProj_;
    private double cosPhiC_;
    private double sinPhiC_;

    public NcArrayLonLatAzimuthalEqualArea(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjection.AZIM_EQUAL_AREA);
        this.initMe();
    }

    private void initMe() {
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcLLAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcLLAltGriddingVarType)vtype).isGrid(NcLLAltGridding.AZIM_EQUAL_AREA)) {
            throw new NcException("Variable is not projected type azimuthal equal-area.");
        }
        this.initGissProj();
    }

    private void initUnidataProj() {
        VariableDS njvarDS = (VariableDS)this.ncvar_.getObject();
        List csList = njvarDS.getCoordinateSystems();
        if (csList == null || csList.isEmpty()) {
            throw new NcException("No coordinate system(s) reported.");
        }
        CoordinateSystem cs = (CoordinateSystem)csList.get(0);
        ProjectionImpl pj = cs.getProjection();
        if (pj == null) {
            throw new NcException("CS returned null projection handler.");
        }
        if (!(pj instanceof LambertAzimuthalEqualArea)) {
            throw new NcException("CS returned wrong proj - " + pj.getClass().getSimpleName());
        }
        this.njProj_ = pj;
    }

    private void initGissProj() {
        this.getGridMappingName();
        if (!this.mappingName_.equalsIgnoreCase("azimuthal_equal_area") && !this.mappingName_.equalsIgnoreCase("lambert_azimuthal_equal_area")) {
            LOGGER.trace("Found unusable mapping name {}", (Object)this.mappingName_);
            throw new NcException("Mapping name is not azimuthal_equal_area or lambert_azimuthal_equal_area");
        }
        this.initCenter();
        this.initRadiusEastingAndNorthing();
        this.cosPhiC_ = Math.cos(Math.toRadians(this.phiC_));
        this.sinPhiC_ = Math.sin(Math.toRadians(this.phiC_));
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return null;
        }
        double lambdaRad = Math.toRadians(lon - this.lambdaC_);
        double cosLambda = Math.cos(lambdaRad);
        double phiRad = Math.toRadians(lat);
        double cosPhi = Math.cos(phiRad);
        double sinPhi = Math.sin(phiRad);
        double k = Math.sqrt(2.0 / (1.0 + this.sinPhiC_ * sinPhi + this.cosPhiC_ * cosPhi * cosLambda));
        double x = k * cosPhi * Math.sin(lambdaRad);
        double y = k * (this.cosPhiC_ * sinPhi - this.sinPhiC_ * cosPhi * cosLambda);
        return new Point2D.Double(x * this.radius_ + this.falseEasting_, y * this.radius_ + this.falseNorthing_);
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double xx = x - this.falseEasting_;
        double yy = y - this.falseNorthing_;
        if (xx == 0.0 && yy == 0.0) {
            return new PointLL(this.lambdaC_, this.phiC_);
        }
        double rho = Math.hypot(xx, yy);
        double c = 2.0 * Math.asin(rho * 0.5 * this.oneOverR_);
        double sinC = Math.sin(c);
        double cosC = Math.cos(c);
        double phiRad = Math.asin(cosC * this.sinPhiC_ + yy * sinC * this.cosPhiC_ / rho);
        double lambdaRad = Math.atan2(xx * sinC, rho * this.cosPhiC_ * cosC - yy * this.sinPhiC_ * sinC);
        return new PointLL(this.lambdaC_ + Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
    }
}

