/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderXY;
import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.VariableDS;

public class NcArrayXY
extends NcArray2D {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Object xAxisInfo_;
    private Object yAxisInfo_;

    public NcArrayXY(NcVariable ncvar, Object xAxisInfo, Object yAxisInfo) throws NcException {
        super(ncvar);
        this.xAxisInfo_ = xAxisInfo;
        this.yAxisInfo_ = yAxisInfo;
        this.setAxes();
        this.measureAxes();
    }

    @Override
    protected void setAxes() {
        int lonindex;
        LOGGER.trace("xAxisInfo_ {}, yAxisInfo_ {}", this.xAxisInfo_, this.yAxisInfo_);
        this.xDimNum_ = this.findAxisDimension(this.xAxisInfo_);
        this.yDimNum_ = this.findAxisDimension(this.yAxisInfo_);
        LOGGER.trace("xxDimNum_ {}, yDimNum_ {}", (Object)this.xDimNum_, (Object)this.yDimNum_);
        this.xAxis_ = this.createAxis(this.xDimNum_, NcAxisType.GEOX);
        this.yAxis_ = this.createAxis(this.yDimNum_, NcAxisType.GEOY);
        CoordinateAxis lonaxis = NcVarUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.LON);
        if (lonaxis instanceof CoordinateAxis1D && lonaxis.getShape()[0] > 0 && (lonindex = this.findDimensionIndex(lonaxis)) != this.xDimNum_ && lonindex != this.yDimNum_) {
            this.setAveDimIndex(lonindex);
        }
    }

    private int findAxisDimension(Object axisInfo) {
        int dimIndex = -1;
        if (axisInfo instanceof NcDimension) {
            Dimension dd = ((NcDimension)axisInfo).getNjDimension();
            for (int i = 0; i < this.rank_; ++i) {
                Dimension d = this.njvarDS_.getDimension(i);
                if (!d.equals(dd)) continue;
                dimIndex = i;
                LOGGER.trace("found A {}", (Object)dimIndex);
                break;
            }
        } else {
            if (axisInfo instanceof Integer) {
                dimIndex = (Integer)axisInfo;
                return dimIndex;
            }
            if (axisInfo instanceof String) {
                String dname = (String)axisInfo;
                for (int i = 0; i < this.rank_; ++i) {
                    Dimension d = this.njvarDS_.getDimension(i);
                    String sname = d.getShortName();
                    String fname = d.getFullName();
                    if (sname == null || fname == null || !sname.equals(dname) && !fname.equals(dname)) continue;
                    dimIndex = i;
                    break;
                }
            } else {
                throw new IllegalArgumentException("Invalid axis info type");
            }
        }
        if (dimIndex < 0) {
            throw new NcException("No matching axis dimension found");
        }
        if (dimIndex > this.rank_) {
            throw new IndexOutOfBoundsException("Axis index out of range");
        }
        if (this.shape_[dimIndex] < 2) {
            throw new NcException("Axis dimension is too short for use");
        }
        return dimIndex;
    }

    private NcAxis createAxis(int dimIndex, NcAxisType atype) {
        Dimension d = this.njvarDS_.getDimension(dimIndex);
        VariableDS njvar = this.dataset_.getCoordinateVariable(d);
        if (njvar == null) {
            LOGGER.trace("Could not find coord var {}", (Object)d.getShortName());
            String fname = d.getShortName();
            int length = d.getLength();
            return new NcAxis(atype, fname, length);
        }
        boolean isPressure = NcVarUtils.isPressure(njvar);
        boolean isHeight = NcVarUtils.isHeight(njvar);
        boolean isDepth = NcVarUtils.isDepth(njvar);
        boolean isUnixTime = NcVarUtils.isUnixTime(njvar);
        LOGGER.trace("pressure? {} -- height? {} -- depth? {}", (Object)isPressure, (Object)isDepth);
        if (isUnixTime) {
            return new NcTimeAxis(this.dataset_, njvar);
        }
        NcAxisType xatype = atype;
        if (isPressure || isHeight || isDepth) {
            LOGGER.debug("Switching axis type {} to VERT", (Object)xatype);
            xatype = NcAxisType.VERT;
        }
        return new NcAxis(xatype, this.dataset_, njvar);
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderXY();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        int col = index[0];
        int row = index[1];
        if (col < 0 || row < 0) {
            sb.append("Pt apparently outside data bounds");
            return;
        }
        int colDisplay = col + 1;
        int rowDisplay = row + 1;
        double x = this.xAxis_.valueAt(col);
        double y = this.yAxis_.valueAt(row);
        sb.append("Cell [").append(colDisplay).append(", ").append(rowDisplay).append("] at [").append(PrintfFormat.PFORMAT_7G.sprintfx(x));
        if (this.xAxis_.getUnitsString() != null) {
            sb.append(' ').append(this.xAxis_.getUnitsString());
        }
        sb.append(", ").append(PrintfFormat.PFORMAT_7G.sprintfx(y));
        if (this.yAxis_.getUnitsString() != null) {
            sb.append(' ').append(this.yAxis_.getUnitsString());
        }
        sb.append("], value = ");
        double gv = this.valueAt(col, row);
        sb.append(valFormat.sprintfx(gv));
        if (Double.isNaN(gv)) {
            return;
        }
        String unitsStr = this.getUnitsString();
        if (unitsStr != null && !unitsStr.isEmpty() && !unitsStr.equals("1")) {
            sb.append(' ').append(unitsStr);
        }
    }
}

