/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderTimeVert;
import gov.nasa.giss.text.PrintfFormat;
import java.util.Objects;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.VariableDS;

public class NcArrayTimeVert
extends NcArray2D {
    public NcArrayTimeVert(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.setAxes();
        this.measureAxes();
    }

    @Override
    protected void setAxes() {
        NcDataset ncd = this.getDataset();
        CoordinateAxis x = NcVarUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.TIME);
        CoordinateAxis y = NcVarUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.VERT);
        if (x == null) {
            VariableDS cv = NcVarUtils.getCoordinateVariable(this.ncvar_, NcAxisType.TIME);
            if (cv != null) {
                this.xAxis_ = new NcTimeAxis(ncd, cv);
                this.xDimNum_ = this.findDimensionIndex(cv);
            }
        } else {
            this.xAxis_ = new NcTimeAxis(ncd, x);
            this.xDimNum_ = this.findDimensionIndex(x);
        }
        if (y != null) {
            this.yAxis_ = new NcAxis(NcAxisType.VERT, ncd, y);
            this.yDimNum_ = this.findDimensionIndex(y);
        }
        if (this.xAxis_ == null) {
            throw new NcException("Got null retrieving TIME coordinate axis");
        }
        if (this.yAxis_ == null) {
            throw new NcException("Got null retrieving VERT coordinate axis");
        }
        if (this.xDimNum_ == -1) {
            throw new NcException("Unable to determine dim index for TIME axis");
        }
        if (this.yDimNum_ == -1) {
            throw new NcException("Unable to determine dim index for VERT axis");
        }
        CoordinateAxis a = NcVarUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.LON);
        if (a != null) {
            this.setAveDimIndex(this.findDimensionIndex(a));
        }
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderTimeVert();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        int col = index[0];
        int row = index[1];
        if (row < 0 || col < 0) {
            sb.append("Pt apparently outside data bounds");
            return;
        }
        int colDisplay = col + 1;
        int rowDisplay = row + 1;
        double time = this.getXAxis().valueAt(col);
        double yy = this.getYAxis().valueAt(row);
        double value = this.valueAt(col, row);
        sb.append("Cell [").append(colDisplay).append(", ").append(rowDisplay).append("] at [").append(PrintfFormat.PFORMAT_7G.sprintfx(time)).append(", ").append(PrintfFormat.PFORMAT_7G.sprintfx(yy));
        if (this.getYAxis().getUnitsString() != null) {
            sb.append(' ').append(this.getYAxis().getUnitsString());
        }
        sb.append("], value = ").append(valFormat.sprintfx(value));
        if (Double.isNaN(value)) {
            return;
        }
        String unitsStr = this.getUnitsString();
        if (unitsStr != null && !unitsStr.isEmpty() && !unitsStr.equals("1")) {
            sb.append(' ').append(unitsStr);
        }
    }
}

