/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcStringUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLatReducedCF;
import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.dataset.VariableDS;

public abstract class NcArrayLonLatReduced
extends NcArray
implements NcArrayLonLat {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected int reduceDimIndex_ = -1;
    protected VariableDS lonVarDS_;
    protected VariableDS latVarDS_;
    protected int numPts_ = -1;
    protected double[] rawLonValues_;
    protected double[] rawLatValues_;
    protected int numRows_ = -1;
    protected double[] rowLatValues_;
    protected double[][] rowLatBounds_;
    protected int[] latOffsets_;
    protected int[] cellsInRow_;
    protected int maxCols_ = -1;
    protected NcAxis yAxis_;

    public NcArrayLonLatReduced(NcVariable ncvar) throws NcException {
        super(ncvar);
    }

    @Override
    protected void createFreeDimensions() {
        this.dimensions_ = new NcDimension[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            this.dimensions_[i] = i == this.reduceDimIndex_ ? null : this.ncvar_.getDimension(i);
        }
    }

    public NcAxis getXAxis(int row) {
        int cols = this.cellsInRow_[row];
        double[] vals = new double[cols];
        for (int i = 0; i < cols; ++i) {
            vals[i] = this.rawLonValues_[this.latOffsets_[row] + i];
            if (i <= 0 || !(vals[i] < vals[i - 1])) continue;
            int n = i;
            vals[n] = vals[n] + 360.0;
        }
        return new NcAxis(NcAxisType.LON, "Longitude", vals);
    }

    public NcAxis getYAxis() {
        return this.yAxis_;
    }

    public int getLength() {
        return this.numPts_;
    }

    public double getReducedLongitudeAt(int index) {
        return this.rawLonValues_[index];
    }

    public double getReducedLatitudeAt(int index) {
        return this.rawLatValues_[index];
    }

    @Override
    protected void findExtrema() {
        double[] range = this.getActualRange();
        if (range != null) {
            this.minimum_ = range[0];
            this.maximum_ = range[1];
            this.needsExtrema_ = false;
            return;
        }
        this.minimum_ = Double.POSITIVE_INFINITY;
        this.maximum_ = Double.NEGATIVE_INFINITY;
        try {
            for (int i = 0; i < this.numPts_; ++i) {
                double value = this.valueAt(i);
                if (this.isMissingOrInvalid(value)) continue;
                if (this.maximum_ < this.minimum_) {
                    this.minimum_ = value;
                    this.maximum_ = value;
                    continue;
                }
                if (value < this.minimum_) {
                    this.minimum_ = value;
                    continue;
                }
                if (!(value > this.maximum_)) continue;
                this.maximum_ = value;
            }
        }
        catch (Exception exc) {
            LOGGER.error(exc.toString());
        }
        if (Double.isInfinite(this.minimum_)) {
            this.minimum_ = Double.NaN;
            this.maximum_ = Double.NaN;
        }
        this.needsExtrema_ = false;
    }

    private void buildLatBounds() {
        this.rowLatBounds_ = new double[this.numRows_][2];
        for (int i = 0; i < this.numRows_; ++i) {
            if (i == 0) {
                this.rowLatBounds_[0][0] = this.rowLatValues_[0] - 0.5 * (this.rowLatValues_[1] - this.rowLatValues_[0]);
                this.rowLatBounds_[0][1] = 0.5 * (this.rowLatValues_[0] + this.rowLatValues_[1]);
            } else if (i == this.numRows_ - 1) {
                this.rowLatBounds_[i][0] = 0.5 * (this.rowLatValues_[i - 1] + this.rowLatValues_[i]);
                this.rowLatBounds_[i][1] = this.rowLatValues_[i] + 0.5 * (this.rowLatValues_[i] - this.rowLatValues_[i - 1]);
            } else {
                this.rowLatBounds_[i][0] = 0.5 * (this.rowLatValues_[i - 1] + this.rowLatValues_[i]);
                this.rowLatBounds_[i][1] = 0.5 * (this.rowLatValues_[i] + this.rowLatValues_[i + 1]);
            }
            if (this.rowLatBounds_[i][0] < -90.0) {
                this.rowLatBounds_[i][0] = -90.0;
            }
            if (this.rowLatBounds_[i][1] < -90.0) {
                this.rowLatBounds_[i][1] = -90.0;
            }
            if (this.rowLatBounds_[i][0] > 90.0) {
                this.rowLatBounds_[i][0] = 90.0;
            }
            if (!(this.rowLatBounds_[i][1] > 90.0)) continue;
            this.rowLatBounds_[i][1] = 90.0;
        }
    }

    @Override
    public int[] getEnclosingCell(double lon, double lat) {
        if (this.rowLatBounds_ == null) {
            this.buildLatBounds();
        }
        int row = -1;
        for (int i = 0; i < this.numRows_; ++i) {
            if (!(lat >= this.rowLatBounds_[i][0]) || !(lat <= this.rowLatBounds_[i][1])) continue;
            row = i;
            break;
        }
        if (row < 0) {
            return null;
        }
        int offset = this.latOffsets_[row];
        int rowLast = offset + this.cellsInRow_[row] - 1;
        for (int j = 0; j < this.cellsInRow_[row]; ++j) {
            double lonL;
            int cell = offset + j;
            int cellP1 = j < this.cellsInRow_[row] - 1 ? cell + 1 : offset;
            int cellM1 = j > 0 ? cell - 1 : rowLast;
            double lon1 = this.rawLonValues_[cell];
            double lonR = this.rawLonValues_[cellP1];
            for (lonL = this.rawLonValues_[cellM1]; lonL > lon1; lonL -= 360.0) {
            }
            while (lonR < lon1) {
                lonR += 360.0;
            }
            double cellLeft = 0.5 * (lonL + lon1);
            double cellRight = 0.5 * (lon1 + lonR);
            if (lon >= cellLeft && lon <= cellRight) {
                return new int[]{cell};
            }
            if (lon + 360.0 >= cellLeft && lon + 360.0 <= cellRight) {
                return new int[]{cell};
            }
            if (!(lon - 360.0 >= cellLeft) || !(lon - 360.0 <= cellRight)) continue;
            return new int[]{cell};
        }
        return null;
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        int col = index[0];
        if (col < 0 || col >= this.numPts_) {
            sb.append("Pt apparently outside data bounds");
            return;
        }
        double lon = this.rawLonValues_[col];
        double lat = this.rawLatValues_[col];
        double gv = this.valueAt(col);
        sb.append("Cell [").append(col + 1).append(']').append(" at [").append(NcStringUtils.formatLongitude(lon)).append(' ').append(NcStringUtils.formatLatitude(lat)).append("], value = ").append(valFormat.sprintfx(gv));
    }

    public double valueAt(int index) {
        if (index < 0 || index >= this.numPts_) {
            throw new IndexOutOfBoundsException("Index out of range: " + index + ", " + this.numPts_);
        }
        if (this.needsSlice_) {
            this.doSlice();
        }
        try {
            return this.getDoubleFromSlice(index);
        }
        catch (Exception exc) {
            LOGGER.error("Slice getDouble failed -  index = {}.{}", (Object)index);
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException(exc.toString());
        }
    }

    public double valueAt(int col, int row) {
        if (row < 0 || row >= this.numRows_) {
            throw new IndexOutOfBoundsException("Row index out of range: " + row + ", " + this.numRows_);
        }
        if (col < 0 || col >= this.cellsInRow_[row]) {
            throw new IndexOutOfBoundsException("Col index out of range: " + col + ", " + this.cellsInRow_[row]);
        }
        if (this.needsSlice_) {
            this.doSlice();
        }
        try {
            int index = this.latOffsets_[row] + col;
            return this.getDoubleFromSlice(index);
        }
        catch (Exception exc) {
            LOGGER.error("Slice getDouble failed - row,col = {}.{}", (Object)row, (Object)col);
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException(exc.toString());
        }
    }

    private double getDoubleFromSlice(int index) {
        int[] ss = new int[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            ss[i] = 0;
        }
        ss[this.reduceDimIndex_] = index;
        this.sliceIdx_.set(ss);
        return this.slice_.getDouble(this.sliceIdx_);
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderLonLatReducedCF();
    }

    private synchronized void doSlice() throws NcException {
        int[] sOrigin = new int[this.rank_];
        int[] sShape = new int[this.rank_];
        try {
            this.needsSlice_ = true;
            for (int i = 0; i < this.rank_; ++i) {
                sOrigin[i] = this.sIndex_[i];
                sShape[i] = 1;
            }
            sOrigin[this.reduceDimIndex_] = 0;
            sShape[this.reduceDimIndex_] = this.numPts_;
            this.slice_ = this.njvarDS_.read(sOrigin, sShape);
            this.sliceIdx_ = this.slice_.getIndex();
            this.needsSlice_ = false;
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException("Do Slice - " + exc.toString());
        }
    }
}

