/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.util.DescribedItem;

public enum NcVarClass implements DescribedItem
{
    GEOREF("Georeferenced variables"),
    GRIDDABLE("Plottable variables"),
    ALL("All variables");

    private final String description_;

    private NcVarClass(String description) {
        this.description_ = description;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    @Override
    public boolean matches(String text) {
        return this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text);
    }

    public static NcVarClass matching(String str) {
        for (NcVarClass item : NcVarClass.values()) {
            if (!item.matches(str)) continue;
            return item;
        }
        return null;
    }
}

