/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcStructureMember;
import gov.nasa.giss.data.nc.NcVarClass;
import gov.nasa.giss.data.nc.ui.NcDataTreeTableModel;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Variable;
import ucar.nc2.dataset.SequenceDS;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;

public class NcStructure
extends NcDataNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final StructureDS njstructDS_;

    public NcStructure(NcDataNode parent, StructureDS s) throws IOException {
        super(parent);
        this.njstructDS_ = s;
        this.initChildren();
    }

    protected void initChildren() {
        this.initAllChildren();
        this.initVisibleChildren();
    }

    private void initAllChildren() {
        if (this.njstructDS_ == null) {
            LOGGER.error("Backing NJ Structure is not set.");
            return;
        }
        this.childNameList_.clear();
        this.allChildren_ = new ArrayList(50);
        for (Variable var : this.njstructDS_.getVariables()) {
            String fname = var.getFullName();
            this.childNameList_.add(fname);
            try {
                NcStructure ncstruct;
                if (var instanceof SequenceDS) {
                    LOGGER.warn("Child {} is a sequence", (Object)var.getShortName());
                    SequenceDS njseqDS = (SequenceDS)var;
                    ncstruct = new NcStructure(this, njseqDS);
                    this.allChildren_.add(ncstruct);
                    continue;
                }
                if (var instanceof StructureDS) {
                    LOGGER.warn("Child {} is a structure", (Object)var.getShortName());
                    StructureDS njstructDS = (StructureDS)var;
                    ncstruct = new NcStructure(this, njstructDS);
                    this.allChildren_.add(ncstruct);
                    continue;
                }
                if (var instanceof VariableDS) {
                    LOGGER.warn("Child {} is a variable", (Object)var.getShortName());
                    VariableDS njvarDS = (VariableDS)var;
                    NcStructureMember ncv = new NcStructureMember(this, njvarDS);
                    this.allChildren_.add(ncv);
                    continue;
                }
                LOGGER.warn("Unexpected data class {}, {}", (Object)var.getShortName(), (Object)var.getClass());
            }
            catch (Exception exc) {
                LOGGER.error("Exception constructing {}, {}", (Object)var.getShortName(), (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) continue;
                exc.printStackTrace();
            }
        }
        LOGGER.trace("count {}", (Object)this.allChildren_.size());
    }

    private void initVisibleChildren() {
        this.clear();
        if (this.njstructDS_ == null) {
            return;
        }
        NcVarClass vclass = this.getVisibleVarClass();
        for (NcDataNode child : this.allChildren_) {
            if (child instanceof NcStructure) {
                this.addSorted(child);
                continue;
            }
            if (child instanceof NcStructureMember) {
                if (vclass != NcVarClass.ALL) continue;
                this.addSorted(child);
                continue;
            }
            LOGGER.warn("Unexpected NcType {}", (Object)child.getClass());
        }
        LOGGER.trace("count {}", (Object)this.getChildren().length);
    }

    @Override
    public void setVisibleVarClass(NcDataTreeTableModel model, NcVarClass vclass) {
        super.setVisibleVarClass(model, vclass);
        if (this.njstructDS_ == null) {
            LOGGER.warn("Backing NJ Structure is not set.");
            return;
        }
        TreeTableNode[] children = this.getChildren();
        if (vclass == NcVarClass.GEOREF || vclass == NcVarClass.GRIDDABLE) {
            for (int i = children.length - 1; i >= 0; --i) {
                NcDataNode node = (NcDataNode)children[i];
                if (!(node instanceof NcStructureMember)) continue;
                this.remove(node);
                if (model == null) continue;
                model.nodeRemoved(this, i, node);
            }
        }
        if (vclass == NcVarClass.ALL) {
            for (NcDataNode child : this.allChildren_) {
                try {
                    NcStructureMember ncv;
                    if (!(child instanceof NcStructureMember) || this.isChildVisible(ncv = (NcStructureMember)child)) continue;
                    int index = this.addSorted(ncv);
                    if (model == null) continue;
                    model.nodeInserted(this, index, ncv);
                }
                catch (Exception exc) {
                    LOGGER.error(exc.toString());
                    if (!LOGGER.isTraceEnabled()) continue;
                    exc.printStackTrace();
                }
            }
        }
    }

    private boolean isChildVisible(NcDataNode node) {
        TreeTableNode[] children = this.getChildren();
        if (children == null || children.length == 0) {
            return false;
        }
        String name = node.getName();
        for (TreeTableNode child : children) {
            boolean matches = name.equals(child.getName());
            if (!matches) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public Object getObject() {
        return this.njstructDS_;
    }

    @Override
    public String getName() {
        return this.getShortName();
    }

    @Override
    public String getNjPath() {
        return this.njstructDS_.getFullName();
    }

    @Override
    public String getLongName() {
        return this.getNjPath();
    }

    @Override
    public String getShortName() {
        return this.njstructDS_.getShortName();
    }

    @Override
    public String getNcType() {
        return "\u2014";
    }

    @Override
    public String getDetail(boolean enhanced) {
        String sname = this.njstructDS_.getShortName();
        String fname = this.njstructDS_.getFullName();
        Variable unenhanced = this.ncdataset_.getNjVariableUnenhanced(fname);
        Variable njvar = this.njstructDS_.getOriginalVariable();
        boolean doubleEnhanced = false;
        if (njvar instanceof VariableEnhanced) {
            LOGGER.trace("Original structure/variable is double enhanced!");
            doubleEnhanced = true;
            njvar = ((VariableEnhanced)((Object)njvar)).getOriginalVariable();
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("<html>").append("<head>");
        this.appendDetailStyle(sb);
        sb.append("</head>").append("<body>").append("<h2>Structure \"").append(sname).append("\"</h2>\n").append("<h3>In file \"").append(this.ncdataset_.getName()).append("\"</h3>\n");
        if (!sname.equals(fname)) {
            sb.append("<p>Structure full name: ").append(fname).append("</p>");
        }
        sb.append("<hr>").append("<pre>").append(StringUtils.escapeHtmlSimplistic(this.njstructDS_.toString())).append("</pre>");
        if (LOGGER.isDebugEnabled()) {
            sb.append("<hr>").append("<p><b>Debug info:</b></p>\n").append("<pre>");
            sb.append("rank ").append(this.getRank()).append('\n');
            int[] shape = this.njstructDS_.getShape();
            sb.append("shape ");
            if (shape == null || shape.length == 0) {
                sb.append("scalar");
            } else {
                for (int i = 0; i < shape.length; ++i) {
                    sb.append("[").append(shape[i]).append("]");
                }
            }
            sb.append('\n');
            sb.append("size ").append(this.njstructDS_.getSize()).append('\n').append("members ").append(this.njstructDS_.getNumberOfMemberVariables()).append('\n').append("</pre>");
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }

    public int getRank() {
        return this.njstructDS_.getRank();
    }

    public int[] getShape() {
        return this.njstructDS_.getShape();
    }
}

