/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcDataGrouping;
import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcFilenameFilter;
import gov.nasa.giss.data.nc.NcGeometryType;
import gov.nasa.giss.data.nc.NcGroup;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.HeadlessException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.EnumSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordSysBuilderIF;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.iosp.IOServiceProvider;

public class NcDataset
extends NcDataGrouping {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private NetcdfDataset njdEnhanced_;
    private NetcdfDataset njdUnenhanced_;
    private NetcdfDataset njdataset_;
    private NetcdfFile njFile_;
    private URL url_;
    private DatasetUrl durl_;
    private String name_;
    private NcGeometryType geometry_;
    private static final EnumSet<NetcdfDataset.Enhance> enhancement_;

    public NcDataset(URL url) throws IOException, FileNotFoundException {
        this(url, true);
    }

    private NcDataset(URL url, boolean enhanced) throws IOException, FileNotFoundException {
        block24: {
            super(null, null);
            this.geometry_ = NcGeometryType.GRIDDED;
            LOGGER.trace("url {}, enhanced {}", (Object)url, (Object)enhanced);
            this.ncdataset_ = this;
            this.url_ = url;
            this.name_ = url.getFile();
            int lastSep = this.name_.lastIndexOf(47);
            if (lastSep > -1) {
                this.name_ = this.name_.substring(lastSep + 1);
            }
            boolean isLocal = this.url_.getProtocol().equalsIgnoreCase("file");
            boolean isNcml = this.name_.toLowerCase().endsWith(".ncml");
            String location = this.url_.toString();
            if (enhanced) {
                LOGGER.debug("Attempt to acquire enhanced dataset {}", (Object)location);
                this.njdEnhanced_ = this.acquireNjDataset(location, true);
                LOGGER.debug("-- Success {}", (Object)(this.njdEnhanced_ != null ? 1 : 0));
            }
            if (isLocal || isNcml) {
                LOGGER.debug("Attempt to acquire UN-enhanced dataset {}", (Object)location);
                this.njdUnenhanced_ = this.acquireNjDataset(location, false);
                LOGGER.debug("-- Success {}", (Object)(this.njdUnenhanced_ != null ? 1 : 0));
            }
            this.njdataset_ = this.njdEnhanced_;
            if (this.njdataset_ == null) {
                this.njdataset_ = this.njdUnenhanced_;
            }
            LOGGER.trace("enhanced {}, unenhanced {}", (Object)(this.njdEnhanced_ != null ? 1 : 0), (Object)(this.njdUnenhanced_ != null ? 1 : 0));
            if (this.njdataset_ == null) {
                throw new RuntimeException("NJ dataset is null. Why was there no prior exception?");
            }
            try {
                String urlStr = this.url_.toString();
                LOGGER.debug("Attempt to open file {}", (Object)urlStr);
                this.njFile_ = NetcdfFiles.open(this.url_.toString());
                LOGGER.debug("-- Success {}", (Object)(this.njFile_ != null ? 1 : 0));
            }
            catch (Exception exc) {
                if (isNcml) break block24;
                LOGGER.warn("Exception opening backing NJ 'file': {}", (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) break block24;
                exc.printStackTrace();
            }
        }
        if (this.njFile_ == null) {
            LOGGER.trace("No file yet. Trying deprecated getReferencedFile.");
            try {
                this.njFile_ = ((NetcdfDataset.Builder)this.njdataset_.toBuilder()).orgFile;
            }
            catch (Exception exc) {
                LOGGER.debug("Exception tring to get referenced file via a builder.");
            }
            LOGGER.debug("-- Success {}", (Object)(this.njFile_ != null ? 1 : 0));
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("== Convention {}", (Object)this.njdataset_.getConventionUsed());
        }
        String fts = this.getGlobalAttributeString("featureType");
        LOGGER.trace("== featureType {}", (Object)fts);
        if (fts == null) {
            fts = this.getGlobalAttributeString("cdm_data_type");
            LOGGER.trace("== cdm_data_type {}", (Object)fts);
        }
        if (fts != null) {
            if ("trajectory".equalsIgnoreCase(fts)) {
                this.geometry_ = NcGeometryType.TRAJECTORY;
            } else if ("trajectoryProfile".equalsIgnoreCase(fts)) {
                this.geometry_ = NcGeometryType.TRAJECTORY_PROFILE;
            } else if ("timeSeries".equalsIgnoreCase(fts)) {
                this.geometry_ = NcGeometryType.TIME_SERIES;
            } else if ("point".equalsIgnoreCase(fts)) {
                this.geometry_ = NcGeometryType.POINT;
            } else if ("profile".equalsIgnoreCase(fts)) {
                this.geometry_ = NcGeometryType.PROFILE;
            } else if ("timeSeriesProfile".equalsIgnoreCase(fts)) {
                this.geometry_ = NcGeometryType.TIME_SERIES_PROFILE;
            }
            LOGGER.trace("== FT geometry {}", (Object)this.geometry_);
        }
        this.setGrouping(this.njdataset_.getRootGroup());
        this.initChildren();
    }

    private NetcdfDataset acquireNjDataset(String location, boolean enhanced) throws HeadlessException, IOException {
        LOGGER.trace("location {}, enhanced {}", (Object)location, (Object)enhanced);
        NetcdfDataset result = null;
        try {
            if (this.durl_ == null) {
                LOGGER.trace("Create DatasetUrl for {}", (Object)location);
                this.durl_ = DatasetUrl.findDatasetUrl(location);
            } else {
                LOGGER.trace("Using previously created DatasetUrl {}", (Object)this.durl_);
            }
            result = enhanced ? NetcdfDatasets.acquireDataset(this.durl_, enhancement_, null) : NetcdfDatasets.acquireDataset(this.durl_, false, null);
            LOGGER.debug("Acquired NJ dataset at {}", (Object)location);
        }
        catch (HeadlessException hexc) {
            throw new HeadlessException("HeadlessException opening dataset.");
        }
        catch (IOException ioe) {
            String msg;
            LOGGER.warn("IOException acquiring {}, enhance {}", (Object)location, (Object)enhanced);
            if (LOGGER.isTraceEnabled()) {
                ioe.printStackTrace();
            }
            if ((msg = ioe.toString()).matches(".*Could not find a table for GRIB file.*")) {
                msg = this.getGribMessage(msg);
            }
            throw new IOException(msg);
        }
        catch (Exception exc) {
            String msg;
            LOGGER.warn("Exception {} acquiring {}, enhance {}", exc.toString(), location, enhanced);
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            if ((msg = exc.toString()).matches(".*Could not find a table for GRIB file.*")) {
                msg = this.getGribMessage(msg);
            }
            throw new IOException(msg);
        }
        return result;
    }

    private String getGribMessage(String origStr) {
        Object msg = origStr.replaceFirst(".*Could not find a table for GRIB file with ", "No GRIB table available for ");
        if (PanPreferences.getSharedInstance().getBoolean("files:grib.strict")) {
            msg = (String)msg + ". You might be able to open this file after disabling GRIB-1 strict mode in Preferences>Files.";
        }
        return msg;
    }

    public String getNcFileTypeID() {
        return this.njdataset_.getFileTypeId();
    }

    public URL getURL() {
        return this.url_;
    }

    public NetcdfDataset getNjDataset() {
        return this.njdataset_;
    }

    public NetcdfDataset getNjDatasetUnenhanced() {
        return this.njdUnenhanced_;
    }

    public boolean isEnhanced() {
        return this.njdEnhanced_ != null;
    }

    public NcGeometryType getGeometry() {
        if (this.geometry_ == null) {
            LOGGER.trace("Geometry has somehow become null.");
            this.geometry_ = NcGeometryType.GRIDDED;
        }
        return this.geometry_;
    }

    public Dimension getNjDimension(String name) {
        return this.njdataset_.findDimension(name);
    }

    public String getGlobalAttributeString(String name) {
        Attribute a = this.njdataset_.findGlobalAttribute(name);
        if (a == null || a.isArray() || !a.isString()) {
            return null;
        }
        return a.getStringValue();
    }

    public Integer getGlobalAttributeInteger(String name) {
        Attribute a = this.njdataset_.findGlobalAttribute(name);
        if (a == null || a.isArray()) {
            return null;
        }
        Number nn = a.getNumericValue();
        if (nn == null) {
            return null;
        }
        return nn.intValue();
    }

    public Group getNjGroupUnenhanced(String fullName) {
        if (this.njdUnenhanced_ == null) {
            return null;
        }
        return this.njdUnenhanced_.findGroup(fullName);
    }

    public NcVariable getVariableAtPath(String path) {
        NcDataNode node = this.getChildAtPath(path);
        if (node instanceof NcVariable) {
            return (NcVariable)node;
        }
        if (node == null) {
            LOGGER.warn("No node at path {}.", (Object)path);
        } else {
            LOGGER.warn("Node at path {} is not a variable", (Object)path);
        }
        return null;
    }

    public VariableDS getVariableDS(String fullName) {
        Variable njvar = this.njdataset_.findVariable(fullName);
        if (njvar instanceof VariableDS) {
            return (VariableDS)njvar;
        }
        return null;
    }

    public Variable getNjVariableUnenhanced(String fullName) {
        if (this.njdUnenhanced_ == null) {
            return null;
        }
        return this.njdUnenhanced_.findVariable(fullName);
    }

    public VariableDS getCoordinateVariable(Dimension d) {
        String dname = d.getFullName();
        if (dname == null) {
            return null;
        }
        VariableDS varDS = this.getVariableDS(dname);
        if (varDS != null) {
            return varDS;
        }
        for (TreeTableNode node : this.getChildren()) {
            Dimension d2;
            NcVariable ncv;
            NcDataNode ncn = (NcDataNode)node;
            if (!(ncn instanceof NcVariable) || !(ncv = (NcVariable)ncn).getName().equalsIgnoreCase(dname) || !(d2 = (varDS = (VariableDS)ncv.getObject()).getDimension(0)).equals(d)) continue;
            return varDS;
        }
        return null;
    }

    public void close() throws IOException {
        if (this.njdEnhanced_ != null) {
            this.njdEnhanced_.close();
            this.njdEnhanced_ = null;
        }
        if (this.njdUnenhanced_ != null) {
            this.njdUnenhanced_.close();
            this.njdUnenhanced_ = null;
        }
        if (this.njFile_ != null) {
            this.njFile_.close();
            this.njFile_ = null;
        }
    }

    @Override
    public Object getObject() {
        return this.njdataset_;
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public String getNjPath() {
        return this.url_.toString();
    }

    @Override
    public String getShortName() {
        return "";
    }

    @Override
    public String getLongName() {
        Attribute a = this.njdataset_.findGlobalAttribute("title");
        if (a != null) {
            return a.getStringValue();
        }
        return this.getName();
    }

    @Override
    public String getNcType() {
        String s = this.url_.toString().toLowerCase();
        if (s.startsWith("file:")) {
            return "Local File";
        }
        if (s.startsWith("http:") || s.startsWith("https:") || s.startsWith("ftp:")) {
            return "Remote File";
        }
        return "-";
    }

    @Override
    public String getDetail(boolean enhanced) {
        boolean showDSEnhanced = enhanced || this.njdUnenhanced_ == null && this.njFile_ == null;
        StringBuilder sb = new StringBuilder(256);
        sb.append("<html>");
        sb.append("<head>");
        this.appendDetailStyle(sb);
        sb.append("</head>").append("<body>");
        sb.append("<h2>File \"").append(this.getName()).append("\"</h2>\n");
        if (LOGGER.isDebugEnabled()) {
            sb.append("<hr>").append("<pre>").append("enhanced: ").append(enhanced).append('\n').append("(njdUnenhanced_ == null): ").append(this.njdUnenhanced_ == null).append('\n').append("(njFile_ == null): ").append(this.njFile_ == null).append('\n').append("showDSEnhanced: ").append(showDSEnhanced).append("</pre>");
        }
        sb.append("<p>File type: ");
        if (showDSEnhanced) {
            sb.append(this.njdataset_.getFileTypeDescription());
        } else if (this.njdUnenhanced_ == null) {
            sb.append(this.njFile_.getFileTypeDescription());
        } else {
            sb.append(this.njdUnenhanced_.getFileTypeDescription());
        }
        sb.append("</p>\n");
        if (showDSEnhanced) {
            String convention;
            int lastDot;
            sb.append("<p><b>");
            if (!enhanced) {
                sb.append("Unable to acquire unenhanced dataset. ");
            }
            sb.append("Showing enhanced mode description.</b></p>");
            sb.append("<p>");
            IOServiceProvider iosp = this.njdataset_.getIosp();
            if (iosp != null) {
                sb.append("IOSP file type: ").append(iosp.getFileTypeDescription()).append("<br>");
                String ss = iosp.getClass().toString();
                if (!LOGGER.isDebugEnabled() && (lastDot = ss.lastIndexOf(46)) > -1) {
                    ss = ss.substring(lastDot + 1);
                }
                sb.append("IOSP class: ").append(ss).append("<br>");
            }
            if ((convention = this.njdataset_.getConventionUsed()) != null && !convention.isEmpty()) {
                if (!LOGGER.isDebugEnabled() && (lastDot = convention.lastIndexOf(46)) > -1) {
                    convention = convention.substring(lastDot + 1);
                }
                sb.append("Convention: ").append(convention).append("<br>");
            }
            if (LOGGER.isDebugEnabled()) {
                try {
                    CoordSysBuilderIF factory = CoordSysBuilder.factory(this.njdataset_, null);
                    if (factory != null) {
                        int lastDot2;
                        String ss = factory.getClass().toString();
                        if (!LOGGER.isDebugEnabled() && (lastDot2 = ss.lastIndexOf(46)) > -1) {
                            ss = ss.substring(lastDot2 + 1);
                        }
                        sb.append("Coordinate system builder: ").append(ss).append("<br>");
                    }
                }
                catch (Exception ignore) {
                    LOGGER.debug("Could not extract coordinate system builder");
                }
            }
            sb.append("</p>");
            if (LOGGER.isDebugEnabled() && iosp != null) {
                sb.append("<hr>").append("IOSP detail:").append("<br>").append("<pre>").append(iosp.getDetailInfo()).append("</pre>");
            }
        }
        sb.append("<hr>").append("<pre>");
        Object detailString = null;
        detailString = showDSEnhanced ? this.njdataset_.toString() : (this.njdUnenhanced_ == null ? this.njFile_.toString() : this.njdUnenhanced_.toString());
        LOGGER.trace("detailString length {}", (Object)((String)detailString).length());
        if (((String)detailString).length() > 300000) {
            LOGGER.info("Detail String is long; truncating.");
            detailString = ((String)detailString).substring(0, 250000) + "\u2026\n\n(truncated to 250,000 chars)";
        }
        sb.append(StringUtils.escapeHtmlSimplistic((String)detailString));
        sb.append("</pre>");
        sb.append("</body>").append("</html>");
        return sb.toString();
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }

    public String getNameRoot() {
        String[] extensions = NcFilenameFilter.getExtensionsArray();
        String lcname = this.name_.toLowerCase();
        for (String s : extensions) {
            if (!lcname.endsWith("." + s.toLowerCase())) continue;
            return this.name_.substring(0, this.name_.length() - s.length() - 1);
        }
        return this.name_;
    }

    public boolean isHdfEos() {
        for (TreeTableNode node : this.getChildren()) {
            NcGroup ndg;
            NcDataNode ncn = (NcDataNode)node;
            if (!(ncn instanceof NcGroup) || !"HDFEOS".equalsIgnoreCase((ndg = (NcGroup)ncn).getName()) && !"HDFEOS_INFORMATION".equalsIgnoreCase(ndg.getName())) continue;
            return true;
        }
        Attribute a = this.njdataset_.findGlobalAttribute("HDFEOSVersion");
        return a != null && a.isString();
    }

    static {
        Set<NetcdfDataset.Enhance> dfltMode = NetcdfDataset.getDefaultEnhanceMode();
        enhancement_ = EnumSet.copyOf(dfltMode);
        enhancement_.add(NetcdfDataset.Enhance.IncompleteCoordSystems);
    }
}

