/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcCatalogDataset;
import gov.nasa.giss.data.nc.NcCatalogNode;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.builder.CatalogBuilder;

public class NcCatalog
extends NcCatalogNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Catalog cat_;
    private boolean childrenInitialized_;

    public NcCatalog(NcCatalogNode parent, URI uri) throws FileNotFoundException, IOException {
        this.setParent(parent);
        CatalogBuilder factory = new CatalogBuilder();
        this.cat_ = factory.buildFromURI(uri);
        if (this.cat_ == null) {
            throw new FileNotFoundException("Got null from buildFromURI");
        }
    }

    private void initChildren() {
        Iterator<Dataset> iterator = this.cat_.getDatasetsLogical().iterator();
        while (iterator.hasNext()) {
            Dataset o;
            Dataset d = o = iterator.next();
            LOGGER.trace("{}, add {}, {}", this.toString(), d.getID(), d.getIdOrPath());
            NcCatalogDataset ncd = new NcCatalogDataset(this, d);
            super.add(ncd);
        }
        this.childrenInitialized_ = true;
    }

    public URI getURI() {
        return this.cat_.getBaseURI();
    }

    @Override
    public String toString() {
        Object name = this.cat_.getName();
        if (name == null) {
            name = "[" + this.cat_.getBaseURI().getHost() + "]";
        }
        return name;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public Object getObject() {
        return this.cat_;
    }

    @Override
    public String getName() {
        String ss = this.cat_.getName();
        if (ss == null) {
            ss = this.cat_.getBaseURI().getHost();
        }
        return ss;
    }

    @Override
    public String getLongName() {
        return this.cat_.getName();
    }

    @Override
    public String getDetail() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("<html>").append("<head>");
        this.appendDetailStyle(sb);
        sb.append("</head>").append("<body>").append("<h2>Catalog \"").append(this.getName()).append("\"</h2>\n").append("<hr>").append("<pre>");
        sb.append("Base URI: ").append(this.cat_.getBaseURI()).append('\n');
        if (this.cat_.getVersion() != null) {
            sb.append("Version:  ").append(this.cat_.getVersion()).append('\n');
        }
        if (this.cat_.getExpires() != null) {
            sb.append("Expires:  ").append(this.cat_.getExpires()).append('\n');
        }
        sb.append("</pre>").append("</body><").append("</html>");
        return sb.toString();
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }

    @Override
    public int getChildCount() {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        return super.getChildCount();
    }

    @Override
    public TreeTableNode getChildAt(int index) {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        return super.getChildAt(index);
    }

    @Override
    public TreeTableNode[] getChildren() {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        return super.getChildren();
    }

    @Override
    public void add(TreeTableNode child) throws IllegalStateException {
        if (!this.childrenInitialized_) {
            this.initChildren();
        }
        super.add(child);
    }
}

