/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.security.nacos;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.config.server.auth.RoleInfo;
import com.alibaba.nacos.config.server.model.User;
import com.alibaba.nacos.console.security.nacos.roles.NacosRoleServiceImpl;
import com.alibaba.nacos.console.security.nacos.users.NacosUserDetails;
import com.alibaba.nacos.console.security.nacos.users.NacosUserDetailsServiceImpl;
import com.alibaba.nacos.console.utils.PasswordEncoderUtil;
import java.util.Collection;
import java.util.List;
import javax.naming.directory.DirContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class LdapAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LdapAuthenticationProvider.class);
    private static final String FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String DEFAULT_PASSWORD = "nacos";
    private static final String LDAP_PREFIX = "LDAP_";
    private static final String DEFAULT_SECURITY_AUTH = "simple";
    @Autowired
    private NacosUserDetailsServiceImpl userDetailsService;
    @Autowired
    private NacosRoleServiceImpl nacosRoleService;
    @Value(value="${nacos.core.auth.ldap.url:ldap://localhost:389}")
    private String ldapUrl;
    @Value(value="${nacos.core.auth.ldap.timeout:3000}")
    private String time;
    @Value(value="${nacos.core.auth.ldap.userdn:cn={0},ou=user,dc=company,dc=com}")
    private String userNamePattern;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        UserDetails userDetails;
        String username = (String)authentication.getPrincipal();
        String password = (String)authentication.getCredentials();
        if (this.isAdmin(username)) {
            UserDetails userDetails2 = this.userDetailsService.loadUserByUsername(username);
            if (PasswordEncoderUtil.matches((String)password, (String)userDetails2.getPassword()).booleanValue()) {
                return new UsernamePasswordAuthenticationToken((Object)userDetails2, (Object)password, userDetails2.getAuthorities());
            }
            return null;
        }
        if (!this.ldapLogin(username, password)) {
            return null;
        }
        try {
            userDetails = this.userDetailsService.loadUserByUsername(LDAP_PREFIX + username);
        }
        catch (UsernameNotFoundException exception) {
            String nacosPassword = PasswordEncoderUtil.encode((String)DEFAULT_PASSWORD);
            this.userDetailsService.createUser(LDAP_PREFIX + username, nacosPassword);
            User user = new User();
            user.setUsername(LDAP_PREFIX + username);
            user.setPassword(nacosPassword);
            userDetails = new NacosUserDetails(user);
        }
        return new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)password, userDetails.getAuthorities());
    }

    private boolean isAdmin(String username) {
        List roleInfos = this.nacosRoleService.getRoles(username);
        if (CollectionUtils.isEmpty((Collection)roleInfos)) {
            return false;
        }
        for (RoleInfo roleinfo : roleInfos) {
            if (!"ROLE_ADMIN".equals(roleinfo.getRole())) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private boolean ldapLogin(String username, String password) throws AuthenticationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean supports(Class<?> aClass) {
        return aClass.equals(UsernamePasswordAuthenticationToken.class);
    }

    private void closeContext(DirContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Exception e) {
                LOG.error("Exception closing context", (Throwable)e);
            }
        }
    }
}

