/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.security.nacos;

import com.alibaba.nacos.auth.common.AuthConfigs;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Component;

@Component
public class JwtTokenManager {
    private static final String AUTHORITIES_KEY = "auth";
    @Autowired
    private AuthConfigs authConfigs;

    public String createToken(Authentication authentication) {
        return this.createToken(authentication.getName());
    }

    public String createToken(String userName) {
        long now = System.currentTimeMillis();
        Date validity = new Date(now + this.authConfigs.getTokenValidityInSeconds() * 1000L);
        Claims claims = Jwts.claims().setSubject(userName);
        return Jwts.builder().setClaims(claims).setExpiration(validity).signWith((Key)Keys.hmacShaKeyFor((byte[])this.authConfigs.getSecretKeyBytes()), SignatureAlgorithm.HS256).compact();
    }

    public Authentication getAuthentication(String token) {
        Claims claims = (Claims)Jwts.parserBuilder().setSigningKey(this.authConfigs.getSecretKeyBytes()).build().parseClaimsJws(token).getBody();
        List authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)((String)claims.get((Object)AUTHORITIES_KEY)));
        User principal = new User(claims.getSubject(), "", (Collection)authorities);
        return new UsernamePasswordAuthenticationToken((Object)principal, (Object)"", (Collection)authorities);
    }

    public void validateToken(String token) {
        Jwts.parserBuilder().setSigningKey(this.authConfigs.getSecretKeyBytes()).build().parseClaimsJws(token);
    }
}

