/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.exception;

import com.alibaba.nacos.auth.exception.AccessException;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class ConsoleExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsoleExceptionHandler.class);

    @ExceptionHandler(value={AccessException.class})
    private ResponseEntity<String> handleAccessException(AccessException e) {
        return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)e.getErrMsg());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    private ResponseEntity<String> handleIllegalArgumentException(IllegalArgumentException e) {
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
    }

    @ExceptionHandler(value={Exception.class})
    private ResponseEntity<String> handleException(Exception e) {
        LOGGER.error("CONSOLE", (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ExceptionUtil.getAllExceptionMsg((Throwable)e));
    }
}

