/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.console.controller;

import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.common.ActionTypes;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.model.RestResultUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.TenantInfo;
import com.alibaba.nacos.config.server.service.repository.PersistService;
import com.alibaba.nacos.console.enums.NamespaceTypeEnum;
import com.alibaba.nacos.console.model.Namespace;
import com.alibaba.nacos.console.model.NamespaceAllInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/console/namespaces"})
public class NamespaceController {
    @Autowired
    private PersistService persistService;
    private final Pattern namespaceIdCheckPattern = Pattern.compile("^[\\w-]+");
    private static final int NAMESPACE_ID_MAX_LENGTH = 128;
    private static final String DEFAULT_NAMESPACE = "public";
    private static final int DEFAULT_QUOTA = 200;
    private static final String DEFAULT_CREATE_SOURCE = "nacos";
    private static final String DEFAULT_NAMESPACE_SHOW_NAME = "Public";
    private static final String DEFAULT_NAMESPACE_DESCRIPTION = "Public Namespace";
    private static final String DEFAULT_TENANT = "";
    private static final String DEFAULT_KP = "1";

    @GetMapping
    public RestResult<List<Namespace>> getNamespaces(HttpServletRequest request, HttpServletResponse response) {
        List tenantInfos = this.persistService.findTenantByKp(DEFAULT_KP);
        Namespace namespace0 = new Namespace(DEFAULT_TENANT, DEFAULT_NAMESPACE, 200, this.persistService.configInfoCount(DEFAULT_TENANT), NamespaceTypeEnum.GLOBAL.getType());
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        namespaces.add(namespace0);
        for (TenantInfo tenantInfo : tenantInfos) {
            int configCount = this.persistService.configInfoCount(tenantInfo.getTenantId());
            Namespace namespaceTmp = new Namespace(tenantInfo.getTenantId(), tenantInfo.getTenantName(), 200, configCount, NamespaceTypeEnum.CUSTOM.getType());
            namespaces.add(namespaceTmp);
        }
        return RestResultUtils.success(namespaces);
    }

    @GetMapping(params={"show=all"})
    public NamespaceAllInfo getNamespace(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="namespaceId") String namespaceId) {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            return new NamespaceAllInfo(namespaceId, DEFAULT_NAMESPACE_SHOW_NAME, 200, this.persistService.configInfoCount(DEFAULT_TENANT), NamespaceTypeEnum.GLOBAL.getType(), DEFAULT_NAMESPACE_DESCRIPTION);
        }
        TenantInfo tenantInfo = this.persistService.findTenantByKp(DEFAULT_KP, namespaceId);
        int configCount = this.persistService.configInfoCount(namespaceId);
        return new NamespaceAllInfo(namespaceId, tenantInfo.getTenantName(), 200, configCount, NamespaceTypeEnum.CUSTOM.getType(), tenantInfo.getTenantDesc());
    }

    @PostMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE)
    public Boolean createNamespace(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="customNamespaceId") String namespaceId, @RequestParam(value="namespaceName") String namespaceName, @RequestParam(value="namespaceDesc", required=false) String namespaceDesc) {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            namespaceId = UUID.randomUUID().toString();
        } else {
            if (!this.namespaceIdCheckPattern.matcher(namespaceId = namespaceId.trim()).matches()) {
                return false;
            }
            if (namespaceId.length() > 128) {
                return false;
            }
            if (this.persistService.tenantInfoCountByTenantId(namespaceId) > 0) {
                return false;
            }
        }
        this.persistService.insertTenantInfoAtomic(DEFAULT_KP, namespaceId, namespaceName, namespaceDesc, DEFAULT_CREATE_SOURCE, System.currentTimeMillis());
        return true;
    }

    @GetMapping(params={"checkNamespaceIdExist=true"})
    public Boolean checkNamespaceIdExist(@RequestParam(value="customNamespaceId") String namespaceId) {
        if (StringUtils.isBlank((CharSequence)namespaceId)) {
            return false;
        }
        return this.persistService.tenantInfoCountByTenantId(namespaceId) > 0;
    }

    @PutMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE)
    public Boolean editNamespace(@RequestParam(value="namespace") String namespace, @RequestParam(value="namespaceShowName") String namespaceShowName, @RequestParam(value="namespaceDesc", required=false) String namespaceDesc) {
        this.persistService.updateTenantNameAtomic(DEFAULT_KP, namespace, namespaceShowName, namespaceDesc);
        return true;
    }

    @DeleteMapping
    @Secured(resource="console/namespaces", action=ActionTypes.WRITE)
    public Boolean deleteConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="namespaceId") String namespaceId) {
        this.persistService.removeTenantInfoAtomic(DEFAULT_KP, namespaceId);
        return true;
    }
}

