/*
 * Decompiled with CFR 0.152.
 */
package net.schmunk.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;
import net.schmunk.ui.FGConstraint;

public class FlexingGridLayout
implements LayoutManager2 {
    private int gridWidth_;
    private int gridHeight_;
    private int hGap_;
    private int vGap_;
    private boolean hRigid_;
    private boolean vRigid_;
    private boolean padTop_;
    private boolean padBottom_;
    private Hashtable<Component, FGConstraint> constraints_;
    private float[] colWeight_;
    private float[] rowWeight_;
    private int[] prefWidths_;
    private int[] prefHeights_;
    private int[] minWidths_;
    private int[] minHeights_;

    public FlexingGridLayout() {
        this(1, 1, 0, 0);
    }

    public FlexingGridLayout(Dimension size) {
        this(size.width, size.height, 0, 0);
    }

    public FlexingGridLayout(int width, int height) {
        this(width, height, 0, 0);
    }

    public FlexingGridLayout(Dimension size, int hGap, int vGap) {
        this(size.width, size.height, hGap, vGap);
    }

    public FlexingGridLayout(int width, int height, int hGap, int vGap) {
        this.setGridSize(width, height);
        this.hGap_ = hGap;
        this.vGap_ = vGap;
        this.constraints_ = new Hashtable();
    }

    public Dimension getGridSize() {
        return new Dimension(this.gridWidth_, this.gridHeight_);
    }

    public void setGridSize(Dimension size) {
        this.setGridSize(size.width, size.height);
    }

    public void setGridSize(int w, int h) {
        int i;
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException("Dimensions must be > 0");
        }
        this.gridWidth_ = w;
        this.gridHeight_ = h;
        this.prefWidths_ = new int[w];
        this.prefHeights_ = new int[h];
        this.minWidths_ = new int[w];
        this.minHeights_ = new int[h];
        this.colWeight_ = new float[w];
        this.rowWeight_ = new float[h];
        for (i = 0; i < w; ++i) {
            this.colWeight_[i] = 1.0f;
        }
        for (i = 0; i < h; ++i) {
            this.rowWeight_[i] = 1.0f;
        }
    }

    public void setRigidWidth(boolean b) {
        this.hRigid_ = b;
    }

    public void setRigidHeight(boolean b) {
        this.vRigid_ = b;
    }

    public void setPadded(boolean top, boolean right, boolean bottom, boolean left) {
        this.padTop_ = top;
        this.padBottom_ = bottom;
    }

    public void setPadBottom(boolean b) {
        this.padBottom_ = b;
    }

    public void setRowWeight(int row, float weight) {
        if (row < 0) {
            throw new IllegalArgumentException("Invalid row index: " + row + " < 0");
        }
        if (row >= this.gridHeight_) {
            throw new IllegalArgumentException("Invalid row index: " + row + " >=" + this.gridHeight_);
        }
        this.rowWeight_[row] = weight < 0.0f ? 0.0f : weight;
    }

    public void setColumnWeight(int col, float weight) {
        if (col < 0) {
            throw new IllegalArgumentException("Invalid column index: " + col + " < 0");
        }
        if (col >= this.gridWidth_) {
            throw new IllegalArgumentException("Invalid column index: " + col + " >= " + this.gridWidth_);
        }
        this.colWeight_[col] = weight < 0.0f ? 0.0f : weight;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        FGConstraint fgc;
        if (constraints == null) {
            throw new IllegalArgumentException("Constraints are null");
        }
        if (constraints instanceof FGConstraint) {
            fgc = (FGConstraint)constraints;
        } else if (constraints instanceof Rectangle) {
            fgc = new FGConstraint((Rectangle)constraints);
        } else if (constraints instanceof Point) {
            fgc = new FGConstraint((Point)constraints);
        } else {
            throw new IllegalArgumentException("Invalid constraints for FG");
        }
        String cclass = comp.getClass().toString();
        Rectangle r = fgc.getLocation();
        if (r.x < 0) {
            throw new IllegalArgumentException("Cannot add " + cclass + " to layout: Location " + r.x + " < 0");
        }
        if (r.y < 0) {
            throw new IllegalArgumentException("Cannot add " + cclass + " to layout: Location " + r.y + " < 0");
        }
        if (r.x >= this.gridWidth_) {
            throw new IllegalArgumentException("Cannot add " + cclass + " to layout: Location " + r.x + " >= width");
        }
        if (r.y >= this.gridHeight_) {
            throw new IllegalArgumentException("Cannot add " + cclass + " to layout: Location " + r.y + " >= height");
        }
        if (r.width < 1) {
            throw new IllegalArgumentException("Cannot add " + cclass + " to layout: Width " + r.width + " < 0");
        }
        if (r.height < 1) {
            throw new IllegalArgumentException("Cannot add " + cclass + " to layout: Height " + r.height + " < 0");
        }
        if (r.x + r.width > this.gridWidth_) {
            throw new IllegalArgumentException("Cannot add " + cclass + " to layout: " + r.x + " + " + r.width + " > width");
        }
        if (r.y + r.height > this.gridHeight_) {
            throw new IllegalArgumentException("Cannot add " + cclass + " to layout: " + r.y + " + " + r.height + " > height");
        }
        this.constraints_.put(comp, fgc);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.constraints_.remove(comp);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.measure(parent, true);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.measure(parent, false);
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private Dimension measure(Container parent, boolean preferred) {
        int i;
        Dimension xsize;
        Dimension csize;
        Dimension msize;
        Dimension psize;
        Rectangle r;
        FGConstraint fgc;
        int i2;
        Dimension size = new Dimension(0, 0);
        if (parent.getComponentCount() == 0) {
            return size;
        }
        int[] widths = preferred ? this.prefWidths_ : this.minWidths_;
        int[] heights = preferred ? this.prefHeights_ : this.minHeights_;
        for (i2 = 0; i2 < this.gridWidth_; ++i2) {
            widths[i2] = 0;
        }
        for (i2 = 0; i2 < this.gridHeight_; ++i2) {
            heights[i2] = 0;
        }
        for (Component c : parent.getComponents()) {
            if (c == null || (fgc = this.constraints_.get(c)) == null) continue;
            r = fgc.getLocation();
            psize = c.getPreferredSize();
            msize = c.getMinimumSize();
            if (msize.width > psize.width && !c.isPreferredSizeSet()) {
                psize.width = msize.width;
            }
            if (msize.height > psize.height && !c.isPreferredSizeSet()) {
                psize.height = msize.height;
            }
            csize = preferred ? psize : msize;
            xsize = c.getMaximumSize();
            if (csize.width > xsize.width) {
                csize.width = xsize.width;
            }
            if (csize.height > xsize.height) {
                csize.height = xsize.height;
            }
            if (r.width == 1) {
                widths[r.x] = Math.max(widths[r.x], csize.width);
            }
            if (r.height != 1) continue;
            heights[r.y] = Math.max(heights[r.y], csize.height);
        }
        for (Component c : parent.getComponents()) {
            int excess;
            int allocated;
            if (c == null || (fgc = this.constraints_.get(c)) == null) continue;
            r = fgc.getLocation();
            psize = c.getPreferredSize();
            msize = c.getMinimumSize();
            if (msize.width > psize.width && !c.isPreferredSizeSet()) {
                psize.width = msize.width;
            }
            if (msize.height > psize.height && !c.isPreferredSizeSet()) {
                psize.height = msize.height;
            }
            csize = preferred ? psize : msize;
            xsize = c.getMaximumSize();
            if (csize.width > xsize.width) {
                csize.width = xsize.width;
            }
            if (csize.height > xsize.height) {
                csize.height = xsize.height;
            }
            if (r.width > 1) {
                int excess2;
                allocated = (r.width - 1) * this.hGap_;
                float weight = 0.0f;
                for (int j = 0; j < r.width; ++j) {
                    int x = r.x + j;
                    weight += this.colWeight_[x];
                    if (x < this.gridWidth_) {
                        allocated += widths[x];
                        continue;
                    }
                    allocated = Short.MAX_VALUE;
                    break;
                }
                if ((excess2 = csize.width - allocated) > 0) {
                    int j;
                    if ((double)weight > 0.0) {
                        float distribute = (float)excess2 / weight;
                        for (j = 0; j < r.width; ++j) {
                            int n = r.x + j;
                            widths[n] = widths[n] + (int)(this.colWeight_[r.x + j] * distribute);
                        }
                    } else {
                        int distribute = excess2 / r.width;
                        for (j = 0; j < r.width; ++j) {
                            int n = r.x + j;
                            widths[n] = widths[n] + distribute;
                        }
                    }
                }
            }
            if (r.height <= 1) continue;
            allocated = (r.height - 1) * this.vGap_;
            for (int j = 0; j < r.height; ++j) {
                int y = r.y + j;
                if (y < this.gridHeight_) {
                    allocated += heights[y];
                    continue;
                }
                allocated = Short.MAX_VALUE;
                break;
            }
            if ((excess = csize.height - allocated) <= 0 || this.padTop_ || this.padBottom_) continue;
            int distribute = excess / r.height;
            for (int j = 0; j < r.height; ++j) {
                int n = r.y + j;
                heights[n] = heights[n] + distribute;
            }
        }
        if (this.hRigid_) {
            int maxwidth = FlexingGridLayout.max(widths);
            for (i = 0; i < this.gridWidth_; ++i) {
                widths[i] = maxwidth;
            }
        }
        if (this.vRigid_) {
            int maxheight = FlexingGridLayout.max(heights);
            for (i = 0; i < this.gridHeight_; ++i) {
                heights[i] = maxheight;
            }
        }
        Insets ins = parent.getInsets();
        for (i = 0; i < this.gridWidth_; ++i) {
            size.width += widths[i];
        }
        for (i = 0; i < this.gridHeight_; ++i) {
            size.height += heights[i];
        }
        size.width += this.hGap_ * (this.gridWidth_ - 1) + ins.left + ins.right;
        size.height += this.vGap_ * (this.gridHeight_ - 1) + ins.top + ins.bottom;
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int addHere;
            int prevAdded;
            float tweight;
            int i;
            int i2;
            if (parent.getComponentCount() == 0) {
                return;
            }
            Dimension laySize = parent.getSize();
            Insets insets = parent.getInsets();
            Dimension prefSize = this.measure(parent, true);
            Dimension minSize = this.measure(parent, false);
            int[] leftEdge = new int[this.gridWidth_ + 1];
            int[] topEdge = new int[this.gridHeight_ + 1];
            int[] rightEdge = new int[this.gridWidth_ + 1];
            int[] bottomEdge = new int[this.gridHeight_ + 1];
            leftEdge[0] = insets.left;
            topEdge[0] = insets.top;
            int xExcess = 0;
            int yExcess = 0;
            if (laySize.width <= minSize.width) {
                for (i2 = 0; i2 < this.gridWidth_; ++i2) {
                    rightEdge[i2] = leftEdge[i2] + this.minWidths_[i2];
                    leftEdge[i2 + 1] = rightEdge[i2] + this.hGap_;
                }
                xExcess = 0;
            } else if (laySize.width < prefSize.width) {
                double ratio = (double)(laySize.width - minSize.width) / (double)(prefSize.width - minSize.width);
                for (i = 0; i < this.gridWidth_; ++i) {
                    int dx = this.prefWidths_[i] - this.minWidths_[i];
                    rightEdge[i] = leftEdge[i] + this.minWidths_[i] + (int)(ratio * (double)dx);
                    leftEdge[i + 1] = rightEdge[i] + this.hGap_;
                }
                xExcess = 0;
            } else {
                for (int i3 = 0; i3 < this.gridWidth_; ++i3) {
                    rightEdge[i3] = leftEdge[i3] + this.prefWidths_[i3];
                    leftEdge[i3 + 1] = rightEdge[i3] + this.hGap_;
                }
                xExcess = laySize.width - prefSize.width;
            }
            if (laySize.height <= minSize.height) {
                for (i2 = 0; i2 < this.gridHeight_; ++i2) {
                    bottomEdge[i2] = topEdge[i2] + this.minHeights_[i2];
                    topEdge[i2 + 1] = bottomEdge[i2] + this.vGap_;
                }
                yExcess = 0;
            } else if (laySize.height < prefSize.height) {
                double ratio = (double)(laySize.height - minSize.height) / (double)(prefSize.height - minSize.height);
                for (i = 0; i < this.gridHeight_; ++i) {
                    int dy = this.prefHeights_[i] - this.minHeights_[i];
                    bottomEdge[i] = topEdge[i] + this.minHeights_[i] + (int)(ratio * (double)dy);
                    topEdge[i + 1] = bottomEdge[i] + this.vGap_;
                }
                yExcess = 0;
            } else {
                for (i2 = 0; i2 < this.gridHeight_; ++i2) {
                    bottomEdge[i2] = topEdge[i2] + this.prefHeights_[i2];
                    topEdge[i2 + 1] = bottomEdge[i2] + this.vGap_;
                }
                yExcess = laySize.height - prefSize.height;
            }
            if (xExcess > 0 && (double)(tweight = FlexingGridLayout.sum(this.colWeight_)) > 0.0) {
                prevAdded = 0;
                for (i = 0; i < this.gridWidth_; ++i) {
                    addHere = (int)(this.colWeight_[i] / tweight * (float)xExcess);
                    int n = i;
                    rightEdge[n] = rightEdge[n] + (addHere + prevAdded);
                    int n2 = i + 1;
                    leftEdge[n2] = leftEdge[n2] + (addHere + prevAdded);
                    prevAdded += addHere;
                }
            }
            if (yExcess > 0) {
                if (this.padTop_ && this.padBottom_) {
                    int ptop = yExcess / 2;
                    int i4 = 0;
                    while (i4 < this.gridHeight_) {
                        int n = i4;
                        bottomEdge[n] = bottomEdge[n] + ptop;
                        int n3 = i4++;
                        topEdge[n3] = topEdge[n3] + ptop;
                    }
                } else if (!this.padBottom_) {
                    if (this.padTop_) {
                        int i5 = 0;
                        while (i5 < this.gridHeight_) {
                            int n = i5;
                            bottomEdge[n] = bottomEdge[n] + yExcess;
                            int n4 = i5++;
                            topEdge[n4] = topEdge[n4] + yExcess;
                        }
                    } else {
                        tweight = FlexingGridLayout.sum(this.rowWeight_);
                        if ((double)tweight > 0.0) {
                            prevAdded = 0;
                            for (i = 0; i < this.gridHeight_; ++i) {
                                addHere = (int)(this.rowWeight_[i] / tweight * (float)yExcess);
                                int n = i;
                                bottomEdge[n] = bottomEdge[n] + (addHere + prevAdded);
                                int n5 = i + 1;
                                topEdge[n5] = topEdge[n5] + (addHere + prevAdded);
                                prevAdded += addHere;
                            }
                        }
                    }
                }
            }
            for (Component c : parent.getComponents()) {
                int dy;
                int dx;
                FGConstraint fgc;
                if (c == null || (fgc = this.constraints_.get(c)) == null) continue;
                Rectangle r = fgc.getLocation();
                double hAlignment = fgc.getHAlignment();
                double vAlignment = fgc.getVAlignment();
                if (r.x >= this.gridWidth_ || r.y >= this.gridHeight_) continue;
                int left = leftEdge[r.x];
                int top = topEdge[r.y];
                int right = r.x + r.width <= this.gridWidth_ ? rightEdge[r.x + r.width - 1] : rightEdge[this.gridWidth_ - 1];
                int bottom = r.y + r.height <= this.gridHeight_ ? bottomEdge[r.y + r.height - 1] : bottomEdge[this.gridHeight_ - 1];
                int w = right - left;
                int h = bottom - top;
                Dimension cprefSize = c.getPreferredSize();
                Dimension cmaxSize = c.getMaximumSize();
                if (!fgc.isFill()) {
                    if (w > cprefSize.width && cprefSize.width > 0) {
                        w = cprefSize.width;
                    }
                    if (w > cmaxSize.width && cmaxSize.width > 0) {
                        w = cmaxSize.width;
                    }
                    if (h > cprefSize.height && cprefSize.height > 0) {
                        h = cprefSize.height;
                    }
                    if (h > cmaxSize.height && cmaxSize.height > 0) {
                        h = cmaxSize.height;
                    }
                }
                if ((dx = right - left - w) > 0) {
                    int shift;
                    if (hAlignment >= 0.0 && hAlignment <= 1.0) {
                        shift = (int)(hAlignment * (double)dx);
                        left += shift;
                    } else if (hAlignment == -1.0) {
                        w = right - left;
                    } else if (!((double)c.getAlignmentX() < 0.0) && !((double)c.getAlignmentX() > 1.0)) {
                        shift = (int)(c.getAlignmentX() * (float)dx);
                        left += shift;
                    }
                }
                if ((dy = bottom - top - h) > 0) {
                    int shift;
                    if (vAlignment >= 0.0 && vAlignment <= 1.0) {
                        shift = (int)(vAlignment * (double)dy);
                        top += shift;
                    } else if (!((double)c.getAlignmentY() < 0.0) && !((double)c.getAlignmentY() > 1.0)) {
                        shift = (int)(c.getAlignmentY() * (float)dy);
                        top += shift;
                    }
                }
                c.setBounds(left, top, w, h);
            }
        }
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    private static int max(int ... intvals) {
        int max = Integer.MIN_VALUE;
        for (int ival : intvals) {
            max = Math.max(max, ival);
        }
        return max;
    }

    private static float sum(float ... fvals) {
        float sum = 0.0f;
        for (float fval : fvals) {
            if (Float.isNaN(fval)) {
                return Float.NaN;
            }
            sum += fval;
        }
        return sum;
    }
}

