/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.util.task;

import gov.nasa.giss.util.task.Task;
import gov.nasa.giss.util.task.TaskEvent;
import gov.nasa.giss.util.task.TaskListener;
import gov.nasa.giss.util.task.TaskQueueEvent;
import gov.nasa.giss.util.task.TaskQueueListener;
import java.awt.EventQueue;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskQueue
implements TaskListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Object lock_ = new Object();
    private ArrayList<Task> tasklist_ = new ArrayList();
    private EventListenerList listenerList_ = new EventListenerList();
    private Task currentTask_;

    public int size() {
        return this.tasklist_.size();
    }

    public Task getCurrentTask() {
        if (this.size() == 0) {
            return null;
        }
        return this.currentTask_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Task task) {
        if (task == null) {
            return;
        }
        Object object = this.lock_;
        synchronized (object) {
            task.addTaskListener(this);
            this.tasklist_.add(task);
        }
        if (this.size() == 1) {
            this.startNextTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Task task) {
        if (task == null) {
            return false;
        }
        if (task == this.currentTask_) {
            return false;
        }
        if (!this.tasklist_.contains(task)) {
            return false;
        }
        Object object = this.lock_;
        synchronized (object) {
            task.removeTaskListener(this);
            this.tasklist_.remove(task);
        }
        return true;
    }

    private boolean startNextTask() {
        Task task;
        if (this.currentTask_ != null) {
            return false;
        }
        if (this.size() < 1) {
            return false;
        }
        this.currentTask_ = task = this.tasklist_.get(0);
        EventQueue.invokeLater(() -> task.execute());
        TaskQueueEvent tqe = new TaskQueueEvent(this, task, 1001);
        for (TaskQueueListener tql : (TaskQueueListener[])this.listenerList_.getListeners(TaskQueueListener.class)) {
            tql.taskStarted(tqe);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueueListener(TaskQueueListener l) {
        Object object = this.lock_;
        synchronized (object) {
            this.listenerList_.add(TaskQueueListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueueListener(TaskQueueListener l) {
        Object object = this.lock_;
        synchronized (object) {
            this.listenerList_.remove(TaskQueueListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueueListeners() {
        Object object = this.lock_;
        synchronized (object) {
            TaskQueueListener[] ll = (TaskQueueListener[])this.listenerList_.getListeners(TaskQueueListener.class);
            for (int i = ll.length - 1; i >= 0; --i) {
                this.removeQueueListener(ll[i]);
            }
        }
    }

    @Override
    public void taskCommenced(TaskEvent e) {
        Task task = (Task)e.getSource();
        TaskQueueEvent tqe = new TaskQueueEvent(this, task, 1001);
        for (TaskQueueListener tql : (TaskQueueListener[])this.listenerList_.getListeners(TaskQueueListener.class)) {
            tql.taskStarted(tqe);
        }
    }

    @Override
    public void taskCanceled(TaskEvent e) {
        Task task = (Task)e.getSource();
        TaskQueueEvent tqe = new TaskQueueEvent(this, task, 1003);
        for (TaskQueueListener tql : (TaskQueueListener[])this.listenerList_.getListeners(TaskQueueListener.class)) {
            tql.taskCanceled(tqe);
        }
        this.taskFinished(task);
    }

    @Override
    public void taskCompleted(TaskEvent e) {
        Task task = (Task)e.getSource();
        TaskQueueEvent tqe = new TaskQueueEvent(this, task, 1002);
        for (TaskQueueListener tql : (TaskQueueListener[])this.listenerList_.getListeners(TaskQueueListener.class)) {
            tql.taskCompleted(tqe);
        }
        this.taskFinished(task);
    }

    private void taskFinished(Task task) {
        if (task == null) {
            LOGGER.warn("Null task.");
            return;
        }
        if (task == this.currentTask_) {
            this.currentTask_ = null;
        }
        this.remove(task);
        if (this.size() > 0) {
            this.startNextTask();
        } else {
            TaskQueueEvent tqe = new TaskQueueEvent(this, null, 0);
            for (TaskQueueListener tql : (TaskQueueListener[])this.listenerList_.getListeners(TaskQueueListener.class)) {
                tql.queueEmptied(tqe);
            }
        }
    }
}

