/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.util.task;

import gov.nasa.giss.util.task.TaskEvent;
import gov.nasa.giss.util.task.TaskListener;
import javax.swing.SwingWorker;
import javax.swing.event.EventListenerList;

public class Task
extends SwingWorker<Object, Object> {
    private EventListenerList listenerList_ = new EventListenerList();
    private String description_;

    public Task() {
        this("");
    }

    public Task(String description) {
        this.description_ = description;
    }

    public String getDescription() {
        return this.description_;
    }

    public boolean isBusy() {
        SwingWorker.StateValue state = this.getState();
        return state == SwingWorker.StateValue.PENDING || state == SwingWorker.StateValue.STARTED;
    }

    protected Object beginTask() {
        return null;
    }

    protected void finishTask() {
    }

    @Override
    public final Object doInBackground() {
        if (this.isCancelled()) {
            return null;
        }
        return this.beginTask();
    }

    @Override
    public final void done() {
        if (!this.isCancelled()) {
            this.finishTask();
        }
        for (TaskListener tl : (TaskListener[])this.listenerList_.getListeners(TaskListener.class)) {
            if (this.isCancelled()) {
                tl.taskCanceled(new TaskEvent(this));
                continue;
            }
            tl.taskCompleted(new TaskEvent(this));
        }
        this.removeTaskListeners();
        super.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskListener(TaskListener l) {
        EventListenerList eventListenerList = this.listenerList_;
        synchronized (eventListenerList) {
            this.listenerList_.add(TaskListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskListener(TaskListener l) {
        EventListenerList eventListenerList = this.listenerList_;
        synchronized (eventListenerList) {
            this.listenerList_.remove(TaskListener.class, l);
        }
    }

    public synchronized void removeTaskListeners() {
        TaskListener[] ll = (TaskListener[])this.listenerList_.getListeners(TaskListener.class);
        for (int i = ll.length - 1; i >= 0; --i) {
            this.removeTaskListener(ll[i]);
        }
    }
}

