/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.treetable;

import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.event.TreeTableEvent;
import gov.nasa.giss.ui.event.TreeTableListener;
import gov.nasa.giss.ui.table.GissTable;
import gov.nasa.giss.ui.treetable.TreeTableCellEditor;
import gov.nasa.giss.ui.treetable.TreeTableCellRenderer;
import gov.nasa.giss.ui.treetable.TreeTableModel;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeTable
extends GissTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Object lock_ = new Object();
    private TreeTableCellRenderer ttCellRenderer_;
    private TreeTableCellEditor ttCellEditor_;
    private TreeTableModel ttModel_;
    private KeyStroke cutKS_;

    public TreeTable(TreeTableModel model) {
        this.ttModel_ = model;
        super.setModel(model);
        this.addListeners();
        ListSelectionModel lsm = this.getSelectionModel();
        lsm.setSelectionMode(0);
        this.setTreeTableCellRenderer(new TreeTableCellRenderer());
        TableColumnModel tcm = this.getColumnModel();
        int ccount = tcm.getColumnCount();
        for (int i = 0; i < ccount; ++i) {
            Class<?> c = model.getColumnClass(i);
            if (c != String.class) continue;
            DefaultTableCellRenderer tcr = new DefaultTableCellRenderer();
            tcr.setHorizontalAlignment(model.getColumnAlignment(i));
            tcm.getColumn(i).setCellRenderer(tcr);
        }
        this.setRowHeight(this.getRowHeight() + 3);
        this.getColumnModel().setColumnSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.expandNodeAtRow(0);
        this.ttModel_.setRootVisible(false);
    }

    private void addListeners() {
        this.addMouseListener(new TTMouseAdapter());
        Action cut = TransferHandler.getCutAction();
        ActionMap am = this.getActionMap();
        Object cutKey = null;
        for (Object key : am.allKeys()) {
            Action a = am.get(key);
            if (a != cut) continue;
            cutKey = key;
            break;
        }
        InputMap im = this.getInputMap(1);
        for (KeyStroke ks : im.allKeys()) {
            Object o = im.get(ks);
            if (!o.equals(cutKey)) continue;
            this.cutKS_ = ks;
            break;
        }
        this.addKeyListener(new TTKeyAdapter());
    }

    public void setTreeTableCellRenderer(TreeTableCellRenderer ttcr) {
        this.ttCellRenderer_ = ttcr;
        this.ttCellEditor_ = new TreeTableCellEditor(this, ttcr);
        TableColumnModel tcm = this.getColumnModel();
        int ccount = tcm.getColumnCount();
        for (int i = 0; i < ccount; ++i) {
            Class<?> c = this.ttModel_.getColumnClass(i);
            if (c != TreeTableModel.class) continue;
            tcm.getColumn(i).setCellRenderer(this.ttCellRenderer_);
            tcm.getColumn(i).setCellEditor(this.ttCellEditor_);
            break;
        }
    }

    public TreeTableModel getTreeTableModel() {
        return this.ttModel_;
    }

    public void makeNodeVisible(TreeTableNode node) {
        int row = this.getRowForNode(node);
        if (row < 0) {
            return;
        }
        this.makeRowVisible(row);
        if (row + 1 < this.getRowCount()) {
            this.makeRowVisible(row + 1);
        }
    }

    public int getRowForNode(TreeTableNode node) {
        if (node == null) {
            return -1;
        }
        return this.ttModel_.getRowForNode(node);
    }

    public TreeTableNode getNodeForRow(int row) {
        if (row < 0) {
            return null;
        }
        return this.ttModel_.getNodeForRow(row);
    }

    public TreeTableNode getNodeForPoint(Point pt) {
        if (pt == null) {
            return null;
        }
        int row = this.rowAtPoint(pt);
        return this.getNodeForRow(row);
    }

    public TreeTableNode getSelectedNode() {
        return this.getNodeForRow(this.getSelectedRow());
    }

    public void setSelectedNode(TreeTableNode node) {
        int row = this.getRowForNode(node);
        if (row < 0) {
            return;
        }
        this.setRowSelectionInterval(row, row);
    }

    @Override
    protected Component prepareComponent(Component c, int row, int col, boolean focused, boolean selected, boolean editing) {
        boolean xfocused = (focused || row == this.editingRow) && GuiUtils.isParentWindowFocused(this);
        boolean xselected = selected || row == this.editingRow;
        return super.prepareComponent(c, row, col, xfocused, xselected, editing);
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    public boolean isRootVisible() {
        return this.ttModel_.isRootVisible();
    }

    public void setRootVisible(boolean isVisible) {
        this.ttModel_.setRootVisible(isVisible);
    }

    public void setLeafIcon(Icon icon) {
        this.ttCellRenderer_.setLeafIcon(icon);
    }

    public void setClosedIcon(Icon icon) {
        this.ttCellRenderer_.setClosedIcon(icon);
    }

    public void setOpenIcon(Icon icon) {
        this.ttCellRenderer_.setOpenIcon(icon);
    }

    public boolean isExpanded(int row) {
        return this.ttModel_.isExpanded(row);
    }

    public void expandNode(TreeTableNode node) {
        this.ttModel_.expandNode(node);
    }

    public void expandNodeAtRow(int row) {
        this.ttModel_.expandNodeAtRow(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTreeTableListener(TreeTableListener l) {
        Object object = this.lock_;
        synchronized (object) {
            this.listenerList.add(TreeTableListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTreeTableListener(TreeTableListener l) {
        Object object = this.lock_;
        synchronized (object) {
            this.listenerList.remove(TreeTableListener.class, l);
        }
    }

    protected void fireSelectionMade(TreeTableNode node, int clicks, int modifiers, Point point) {
        LOGGER.trace("{}, {}, {}", clicks, modifiers, point);
        int id = clicks == -1 ? 103 : (clicks < 2 ? 101 : 102);
        TreeTableEvent e = new TreeTableEvent(this, node, id, point);
        TreeTableListener[] listeners = (TreeTableListener[])this.listenerList.getListeners(TreeTableListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].selectionMade(e);
        }
    }

    protected void fireRemovalRequested(TreeTableNode node, int modifiers) {
        TreeTableEvent e = new TreeTableEvent(this, node, 131, null);
        TreeTableListener[] listeners = (TreeTableListener[])this.listenerList.getListeners(TreeTableListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].removalRequested(e);
        }
    }

    private class TTKeyAdapter
    extends KeyAdapter {
        private TTKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            TreeTableNode node = TreeTable.this.getSelectedNode();
            KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
            if (TreeTable.this.cutKS_ != null && ks.equals(TreeTable.this.cutKS_) || e.getKeyCode() == 127) {
                TreeTable.this.fireRemovalRequested(node, e.getModifiersEx());
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            TreeTableNode node = TreeTable.this.getSelectedNode();
            if (e.getKeyCode() == 40 || e.getKeyCode() == 38) {
                TreeTable.this.fireSelectionMade(node, 1, e.getModifiersEx(), null);
            } else if (e.getKeyCode() == 37 || e.getKeyCode() == 226) {
                if (node.getAllowsChildren()) {
                    TreeTable.this.ttModel_.collapseNode(node);
                }
                TreeTable.this.repaint();
            } else if (e.getKeyCode() == 39 || e.getKeyCode() == 227) {
                if (node.getAllowsChildren()) {
                    TreeTable.this.ttModel_.expandNode(node);
                }
                TreeTable.this.repaint();
            }
            if ((e.getKeyCode() == 8 || e.getKeyCode() == 127) && e.getModifiersEx() == 0) {
                TreeTable.this.fireRemovalRequested(node, e.getModifiersEx());
            }
            KeyStroke ks = KeyStroke.getKeyStrokeForEvent(e);
            if (TreeTable.this.cutKS_ != null && ks.equals(TreeTable.this.cutKS_)) {
                TreeTable.this.fireRemovalRequested(node, e.getModifiersEx());
            }
        }
    }

    private class TTMouseAdapter
    extends MouseAdapter {
        private TTMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            LOGGER.trace("");
            if (e.isPopupTrigger()) {
                this.doPopup(e);
            } else {
                Point p = e.getPoint();
                TreeTableNode node = TreeTable.this.getNodeForPoint(p);
                TreeTable.this.fireSelectionMade(node, 0, e.getModifiersEx(), e.getPoint());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            LOGGER.trace("");
            if (e.isPopupTrigger()) {
                this.doPopup(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            LOGGER.trace("{}", (Object)p);
            TreeTableNode node = TreeTable.this.getNodeForPoint(p);
            TreeTable.this.fireSelectionMade(node, e.getClickCount(), e.getModifiersEx(), e.getPoint());
        }

        private void doPopup(MouseEvent e) {
            Point p = e.getPoint();
            TreeTableNode node = TreeTable.this.getNodeForPoint(p);
            if (node == null) {
                return;
            }
            TreeTable.this.fireSelectionMade(node, -1, e.getModifiersEx(), e.getPoint());
        }
    }
}

