/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.table;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.ui.plaf.EmphasizedLabelUI;
import gov.nasa.giss.ui.table.TableHeaderTheme;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableCellRenderer;

public class RowHeaderRenderer
extends JLabel
implements TableCellRenderer {
    private static final String EMPHASIZED_CLASS_ID = "EmphasizedLabelUI";
    private JTable table_;
    private TableHeaderTheme theme_;
    private int[] pressedRows_ = new int[]{-1, -1};
    private int[] selectedRows_ = new int[]{-1, -1};
    private Color topColor_;
    private Color bottomColor_;
    private boolean emphasized_;

    public RowHeaderRenderer() {
        this(TableHeaderTheme.getTheme(null));
    }

    public RowHeaderRenderer(TableHeaderTheme theme) {
        super("");
        this.setTheme(theme);
        this.setOpaque(false);
    }

    public RowHeaderRenderer(JTable table) {
        this();
        this.table_ = table;
    }

    public TableHeaderTheme getTheme() {
        return this.theme_;
    }

    public void setTheme(TableHeaderTheme theme) {
        this.theme_ = theme;
        this.topColor_ = this.theme_.getColor(TableHeaderTheme.TParamKey.UNSELECTED_TOP_COLOR);
        this.bottomColor_ = this.theme_.getColor(TableHeaderTheme.TParamKey.UNSELECTED_BOTTOM_COLOR);
        int fstyle = this.theme_.getInt(TableHeaderTheme.TParamKey.FONT_STYLE);
        this.setFont(UIManager.getFont("TableHeader.font").deriveFont(fstyle));
        this.emphasized_ = this.theme_.getBoolean(TableHeaderTheme.TParamKey.FONT_EMPHASIZED);
    }

    @Override
    public void updateUI() {
        if (this.emphasized_) {
            if (UIManager.get(this.getUIClassID()) != null) {
                this.setUI((EmphasizedLabelUI)UIManager.getUI(this));
            } else {
                this.setUI(EmphasizedLabelUI.createUI(this));
            }
        } else {
            super.updateUI();
        }
    }

    @Override
    public String getUIClassID() {
        if (this.emphasized_) {
            return EMPHASIZED_CLASS_ID;
        }
        return super.getUIClassID();
    }

    public void clear() {
        this.pressedRows_[0] = -1;
        this.pressedRows_[1] = -1;
        this.selectedRows_[0] = -1;
        this.selectedRows_[1] = -1;
    }

    public void setPressedRows(int row0, int row1) {
        this.pressedRows_[0] = row0;
        this.pressedRows_[1] = row1;
        this.selectedRows_[0] = -1;
        this.selectedRows_[1] = -1;
    }

    public int[] getSelectedRows() {
        return this.selectedRows_;
    }

    public void setSelectedRows(int row0, int row1) {
        this.selectedRows_[0] = row0;
        this.selectedRows_[1] = row1;
        this.pressedRows_[0] = -1;
        this.pressedRows_[1] = -1;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        this.setText(value.toString());
        Window window = SwingUtilities.getWindowAncestor(this.table_);
        if (window == null) {
            return this;
        }
        boolean windowHasFocus = window.isFocused();
        Color bcolor = this.theme_.getColor(TableHeaderTheme.TParamKey.BOTTOM_BORDER_COLOR);
        CompoundBorder leftSpacerBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, this.getLeftBorderColor(row, windowHasFocus)), BorderFactory.createEmptyBorder(1, 4, 0, 4));
        CompoundBorder bottomRightBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, bcolor), BorderFactory.createMatteBorder(0, 0, 0, 1, this.getRightBorderColor(row, windowHasFocus)));
        this.setBorder(BorderFactory.createCompoundBorder(bottomRightBorder, leftSpacerBorder));
        this.topColor_ = this.getTopColor(row, windowHasFocus);
        this.bottomColor_ = this.getBottomColor(row, windowHasFocus);
        return this;
    }

    private Color getTopColor(int row, boolean windowHasFocus) {
        if (!windowHasFocus) {
            return this.theme_.getColor(TableHeaderTheme.TParamKey.UNSELECTED_TOP_COLOR);
        }
        if (this.isSelectedRow(row) && this.isPressedRow(row)) {
            return this.theme_.getColor(TableHeaderTheme.TParamKey.PRESSED_SELECTED_TOP_COLOR);
        }
        if (this.isSelectedRow(row)) {
            return this.theme_.getColor(TableHeaderTheme.TParamKey.SELECTED_TOP_COLOR);
        }
        if (this.isPressedRow(row)) {
            return this.theme_.getColor(TableHeaderTheme.TParamKey.PRESSED_UNSELECTED_TOP_COLOR);
        }
        return this.theme_.getColor(TableHeaderTheme.TParamKey.UNSELECTED_TOP_COLOR);
    }

    private Color getBottomColor(int row, boolean windowHasFocus) {
        if (!windowHasFocus) {
            return this.theme_.getColor(TableHeaderTheme.TParamKey.UNSELECTED_BOTTOM_COLOR);
        }
        if (this.isSelectedRow(row) && this.isPressedRow(row)) {
            return this.theme_.getColor(TableHeaderTheme.TParamKey.PRESSED_SELECTED_BOTTOM_COLOR);
        }
        if (this.isSelectedRow(row)) {
            return this.theme_.getColor(TableHeaderTheme.TParamKey.SELECTED_BOTTOM_COLOR);
        }
        if (this.isPressedRow(row)) {
            return this.theme_.getColor(TableHeaderTheme.TParamKey.PRESSED_UNSELECTED_BOTTOM_COLOR);
        }
        return this.theme_.getColor(TableHeaderTheme.TParamKey.UNSELECTED_BOTTOM_COLOR);
    }

    private Color getLeftBorderColor(int row, boolean windowHasFocus) {
        if (!windowHasFocus) {
            return this.theme_.getColor(TableHeaderTheme.TParamKey.LEFT_UNSELECTED_BORDER_COLOR);
        }
        if (this.isSelectedRow(row) && this.isPressedRow(row)) {
            return this.theme_.getColor(TableHeaderTheme.TParamKey.LEFT_SELECTED_BORDER_COLOR);
        }
        if (this.isSelectedRow(row)) {
            return this.theme_.getColor(TableHeaderTheme.TParamKey.LEFT_SELECTED_BORDER_COLOR);
        }
        if (this.isPressedRow(row)) {
            return this.theme_.getColor(TableHeaderTheme.TParamKey.LEFT_PRESSED_UNSELECTED_BORDER_COLOR);
        }
        return this.theme_.getColor(TableHeaderTheme.TParamKey.LEFT_UNSELECTED_BORDER_COLOR);
    }

    private Color getRightBorderColor(int row, boolean windowHasFocus) {
        if (windowHasFocus && this.isSelectedRow(row)) {
            return this.theme_.getColor(TableHeaderTheme.TParamKey.RIGHT_SELECTED_BORDER_COLOR);
        }
        return this.theme_.getColor(TableHeaderTheme.TParamKey.RIGHT_UNSELECTED_BORDER_COLOR);
    }

    private boolean isPressedRow(int row) {
        if (this.pressedRows_[0] == -1 || this.pressedRows_[1] == -1) {
            return false;
        }
        if (this.pressedRows_[1] < this.pressedRows_[0]) {
            return row >= this.pressedRows_[1] & row <= this.pressedRows_[0];
        }
        return row >= this.pressedRows_[0] & row <= this.pressedRows_[1];
    }

    private boolean isSelectedRow(int row) {
        if (this.selectedRows_[0] == -1 || this.selectedRows_[1] == -1) {
            return false;
        }
        if (this.selectedRows_[1] < this.selectedRows_[0]) {
            return row >= this.selectedRows_[1] & row <= this.selectedRows_[0];
        }
        return row >= this.selectedRows_[0] & row <= this.selectedRows_[1];
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, this.topColor_, 0.0f, this.getHeight(), this.bottomColor_);
        g2d.setPaint(paint);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        super.paintComponent(g2d);
        g2d.dispose();
    }
}

