/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.table;

import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.table.ColumnHeaderRenderer;
import gov.nasa.giss.ui.table.GissTableCellBorder;
import gov.nasa.giss.ui.table.RowHeaderRenderer;
import gov.nasa.giss.ui.table.TableHeaderTheme;
import gov.nasa.giss.ui.table.TableMouseListener;
import gov.nasa.giss.ui.table.TableRowHeader;
import gov.nasa.giss.ui.table.TableTheme;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class GissTable
extends JTable {
    private static final TableTheme DEFAULT_THEME = TableTheme.getTheme(null);
    private static final Color UNFOCUSED_SELECTED_CELL_BACKGROUND_COLOR = new Color(192, 192, 192);
    private TableTheme theme_;
    private TableMouseListener mouseAdapter_;
    private TableRowHeader rowHeader_;

    public GissTable() {
        this.initMe(DEFAULT_THEME);
    }

    public GissTable(TableModel model) {
        this(model, DEFAULT_THEME);
    }

    public GissTable(TableModel model, TableTheme theme) {
        super(model);
        this.initMe(theme);
    }

    private void initMe(TableTheme theme) {
        this.setIntercellSpacing(new Dimension());
        ColumnHeaderRenderer thr = new ColumnHeaderRenderer(this);
        thr.setHorizontalAlignment(0);
        JTableHeader colHeader = this.getTableHeader();
        colHeader.setDefaultRenderer(thr);
        colHeader.setReorderingAllowed(false);
        this.setTheme(theme);
        this.mouseAdapter_ = new TableMouseListener(this);
        this.addMouseListener(this.mouseAdapter_);
        this.addMouseMotionListener(this.mouseAdapter_);
        colHeader.addMouseListener(this.mouseAdapter_);
        colHeader.addMouseMotionListener(this.mouseAdapter_);
        ActionMap map = this.getActionMap();
        Action a = TransferHandler.getCopyAction();
        map.put(a.getValue("Name"), a);
    }

    public TableRowHeader getTableRowHeader() {
        return this.rowHeader_;
    }

    public void setTableRowHeader(TableRowHeader header) {
        this.rowHeader_ = header;
        if (this.theme_ != null) {
            TableHeaderTheme htheme = this.theme_.getHeaderTheme();
            TableCellRenderer tcr = this.rowHeader_.getDefaultRenderer(Object.class);
            ((RowHeaderRenderer)tcr).setTheme(htheme);
        }
        this.rowHeader_.addMouseListener(this.mouseAdapter_);
        this.rowHeader_.addMouseMotionListener(this.mouseAdapter_);
    }

    public TableTheme getTheme() {
        return this.theme_;
    }

    public void setTheme(TableTheme theme) {
        this.theme_ = theme;
        if (this.theme_ == null) {
            this.setGridColor(UIManager.getColor("Table.gridColor"));
        } else {
            this.setGridColor(this.theme_.getGridColor());
            this.setShowVerticalLines(theme.getShowVerticalLines());
            this.setShowHorizontalLines(theme.getShowHorizontalLines());
        }
        TableHeaderTheme htheme = theme.getHeaderTheme();
        JTableHeader colHeader = this.getTableHeader();
        TableCellRenderer tcr = colHeader.getDefaultRenderer();
        if (tcr instanceof ColumnHeaderRenderer) {
            ((ColumnHeaderRenderer)tcr).setTheme(htheme);
        }
        if (this.rowHeader_ != null) {
            TableCellRenderer tcr2 = this.rowHeader_.getDefaultRenderer(Object.class);
            ((RowHeaderRenderer)tcr2).setTheme(htheme);
        }
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tcr, int row, int col) {
        return this.prepareComponent(super.prepareRenderer(tcr, row, col), row, col, this.hasFocus(), this.isCellSelected(row, col), false);
    }

    @Override
    public Component prepareEditor(TableCellEditor tce, int row, int col) {
        return this.prepareComponent(super.prepareEditor(tce, row, col), row, col, this.hasFocus(), this.isCellSelected(row, col), true);
    }

    protected Component prepareComponent(Component c, int row, int col, boolean focused, boolean selected, boolean editing) {
        if (editing) {
            c.setBackground(UIManager.getColor("TextField.background"));
            c.setForeground(UIManager.getColor("Table.foreground"));
        } else if (selected) {
            if (PlatformUtils.isMacintosh() && !focused) {
                c.setBackground(UNFOCUSED_SELECTED_CELL_BACKGROUND_COLOR);
                c.setForeground(UIManager.getColor("Table.foreground"));
            } else {
                c.setBackground(UIManager.getColor("Table.selectionBackground"));
                c.setForeground(UIManager.getColor("Table.selectionForeground"));
            }
        } else if (this.theme_ == null) {
            c.setBackground(UIManager.getColor("Table.background"));
            c.setForeground(UIManager.getColor("Table.foreground"));
        } else {
            c.setBackground(this.theme_.getBackground(row));
            c.setForeground(this.theme_.getForeground());
        }
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            if (c instanceof JButton || c instanceof JCheckBox) {
                if (PlatformUtils.isMacintosh()) {
                    jc.setOpaque(false);
                    GuiUtils.setSizeMini(jc);
                } else if (!PlatformUtils.isWindows()) {
                    jc.setOpaque(true);
                }
            }
            if (editing) {
                jc.setBorder(UIManager.getBorder("TextField.border"));
            } else if (!(c instanceof JButton)) {
                jc.setBorder(new GissTableCellBorder(this, row, col, selected, focused));
            }
        }
        return c;
    }

    @Override
    protected void configureEnclosingScrollPane() {
        Container gp;
        super.configureEnclosingScrollPane();
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane sp = (JScrollPane)gp;
            ColumnHeaderRenderer renderer1 = new ColumnHeaderRenderer();
            ColumnHeaderRenderer renderer2 = new ColumnHeaderRenderer();
            ColumnHeaderRenderer renderer3 = new ColumnHeaderRenderer();
            ColumnHeaderRenderer renderer4 = new ColumnHeaderRenderer();
            TableHeaderTheme htheme = this.theme_.getHeaderTheme();
            renderer1.setTheme(htheme);
            renderer2.setTheme(htheme);
            renderer3.setTheme(htheme);
            renderer4.setTheme(htheme);
            Color bcolor = htheme.getColor(TableHeaderTheme.TParamKey.BOTTOM_BORDER_COLOR);
            Color lcolor = htheme.getColor(TableHeaderTheme.TParamKey.LEFT_UNSELECTED_BORDER_COLOR);
            Color rcolor = htheme.getColor(TableHeaderTheme.TParamKey.RIGHT_UNSELECTED_BORDER_COLOR);
            renderer1.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, bcolor), BorderFactory.createMatteBorder(0, 0, 0, 1, rcolor)));
            renderer2.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, bcolor), BorderFactory.createMatteBorder(0, 1, 0, 0, lcolor)));
            renderer3.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, bcolor), BorderFactory.createMatteBorder(0, 0, 0, 1, rcolor)));
            renderer4.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, bcolor), BorderFactory.createMatteBorder(0, 1, 0, 0, lcolor)));
            sp.setCorner("UPPER_LEFT_CORNER", renderer1);
            sp.setCorner("UPPER_RIGHT_CORNER", renderer2);
            sp.setCorner("LOWER_LEFT_CORNER", renderer3);
            sp.setCorner("LOWER_RIGHT_CORNER", renderer4);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintEmptyRows(g);
    }

    protected void paintEmptyRows(Graphics g) {
        int rowCount = this.getRowCount();
        Rectangle clip = g.getClipBounds();
        int height = clip.y + clip.height;
        if (rowCount * this.rowHeight < height) {
            int rows = height / this.rowHeight;
            if (this.theme_ != null) {
                for (int i = rowCount; i <= rows; ++i) {
                    g.setColor(this.theme_.getBackground(i));
                    g.fillRect(clip.x, i * this.rowHeight, clip.width, this.rowHeight);
                }
            }
            if (this.getShowVerticalLines()) {
                g.setColor(this.getGridColor());
                TableColumnModel columnModel = this.getColumnModel();
                int x = 0;
                for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                    TableColumn column = columnModel.getColumn(i);
                    g.drawLine((x += column.getWidth()) - 1, rowCount * this.rowHeight, x - 1, height);
                }
            }
            if (this.getShowHorizontalLines()) {
                g.setColor(this.getGridColor());
                int y = rowCount * this.rowHeight - 1;
                g.drawLine(clip.x, y, clip.width, y);
                for (int i = rowCount; i <= rows; ++i) {
                    y = (i + 1) * this.rowHeight - 1;
                    g.drawLine(clip.x, y, clip.width, y);
                }
            }
        }
    }

    public void repaintHeaders() {
        if (this.getTableHeader() != null) {
            this.getTableHeader().repaint();
        }
        if (this.rowHeader_ != null) {
            this.rowHeader_.repaint();
        }
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            JViewport parent = (JViewport)this.getParent();
            return parent.getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    private boolean isColumnVisible(int col) {
        if (col < 0) {
            throw new IndexOutOfBoundsException(col + " < 0");
        }
        if (col >= this.getColumnCount()) {
            throw new IndexOutOfBoundsException(col + " >= " + this.getColumnCount());
        }
        Rectangle r = this.getCellRect(-1, col, true);
        Insets ins = this.getInsets();
        r.y = ins.top;
        r.height = this.getHeight() - ins.top - ins.bottom;
        Rectangle tRect = this.getVisibleRect();
        return tRect.x <= r.x && tRect.x + tRect.width >= r.x + r.width;
    }

    private boolean isRowVisible(int row) {
        if (row < 0) {
            throw new IndexOutOfBoundsException(row + " < 0");
        }
        if (row >= this.getRowCount()) {
            throw new IndexOutOfBoundsException(row + " >= " + this.getRowCount());
        }
        Rectangle r = this.getCellRect(row, -1, true);
        Insets ins = this.getInsets();
        r.x = ins.left;
        r.width = this.getWidth() - ins.left - ins.right;
        Rectangle tRect = this.getVisibleRect();
        return tRect.y <= r.y && tRect.y + tRect.height >= r.y + r.height;
    }

    public void makeColumnVisible(int col) {
        if (this.isColumnVisible(col)) {
            return;
        }
        int rowCount = this.getRowCount();
        int row = 0;
        for (int i = 0; i < rowCount; ++i) {
            if (!this.isRowVisible(i)) continue;
            row = i;
            break;
        }
        Rectangle r = this.getCellRect(row, col, true);
        this.scrollRectToVisible(r);
    }

    public void makeRowVisible(int row) {
        if (this.isRowVisible(row)) {
            return;
        }
        int colCount = this.getColumnCount();
        int col = 0;
        for (int i = 0; i < colCount; ++i) {
            if (!this.isColumnVisible(i)) continue;
            col = i;
            break;
        }
        Rectangle r = this.getCellRect(row, col, true);
        this.scrollRectToVisible(r);
    }

    public void selectColumns(int col0, int col1) {
        int rowCount = this.getRowCount();
        this.requestFocus();
        this.setColumnSelectionInterval(col0, col1);
        if (rowCount > 0) {
            this.setRowSelectionInterval(0, rowCount - 1);
            this.makeColumnVisible(col1);
        }
        this.repaint();
    }

    public void selectRows(int row0, int row1) {
        int colCount = this.getColumnCount();
        this.requestFocus();
        this.setRowSelectionInterval(row0, row1);
        if (colCount > 0) {
            this.setColumnSelectionInterval(0, colCount - 1);
            this.makeRowVisible(row1);
        }
        this.repaint();
    }

    @Override
    public void clearSelection() {
        super.clearSelection();
        this.clearColumnHeaders();
        this.clearRowHeaders();
    }

    public void clearColumnHeaders() {
        TableCellRenderer tcr = this.getColumnHeaderRenderer(0);
        if (tcr instanceof ColumnHeaderRenderer) {
            ((ColumnHeaderRenderer)tcr).clear();
        }
        this.repaintHeaders();
    }

    public void clearRowHeaders() {
        if (this.rowHeader_ == null) {
            return;
        }
        int rowCount = this.getRowCount();
        if (rowCount < 1) {
            return;
        }
        TableCellRenderer r = this.rowHeader_.getCellRenderer(0, 0);
        if (r instanceof RowHeaderRenderer) {
            RowHeaderRenderer trhr = (RowHeaderRenderer)r;
            trhr.clear();
        }
        this.repaintHeaders();
    }

    public TableCellRenderer getColumnHeaderRenderer(int col) {
        JTableHeader colHeader = this.getTableHeader();
        TableColumnModel tcm = this.getColumnModel();
        try {
            TableColumn tc = tcm.getColumn(col);
            TableCellRenderer r = tc.getHeaderRenderer();
            if (r == null) {
                r = colHeader.getDefaultRenderer();
            }
            return r;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public TableCellRenderer getRowHeaderRenderer(int row) {
        if (this.rowHeader_ == null) {
            return null;
        }
        return this.rowHeader_.getCellRenderer(row, 0);
    }
}

