/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.plaf;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.ui.label.MultiLineLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class MultiLineLabelUI
extends ComponentUI {
    public static final int LEFT = 2;
    public static final int CENTER = 0;
    public static final int RIGHT = 4;
    public static final int TOP = 1;
    public static final int BOTTOM = 3;
    private static final int LSPACE = 1;

    public static ComponentUI createUI(JComponent c) {
        return new MultiLineLabelUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(false);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Color oc = g.getColor();
        MultiLineLabel label = (MultiLineLabel)c;
        if (label.isEnabled()) {
            g.setColor(label.getForeground());
            this.paintText(label, g);
        } else {
            g.setColor(label.getBackground().brighter());
            this.paintText(label, g);
            g.translate(1, 1);
            g.setColor(label.getBackground().darker());
            this.paintText(label, g);
            g.translate(-1, -1);
        }
        g.setColor(oc);
        g.setFont(label.getFont());
    }

    protected void paintText(MultiLineLabel label, Graphics g) {
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        TextInfo info = this.getTextInfo(label);
        String[] lines = info.getLines();
        int lheight = info.getLineHeight();
        int[] lwidths = info.getLineWidths();
        Dimension size = label.getSize();
        Insets ins = label.getInsets();
        int halign = label.getHorizontalAlignment();
        int valign = label.getVerticalAlignment();
        int y = valign == 0 ? (size.height - lines.length * (lheight + 1)) / 2 : (valign == 3 ? size.height - ins.bottom - (lines.length - 1) * (lheight + 1) : ins.top + info.getLineAscent());
        int i = 0;
        while (i < lines.length) {
            int x = halign == 0 ? (size.width - lwidths[i]) / 2 : (halign == 4 ? size.width - ins.right - lwidths[i] : ins.left);
            BasicGraphicsUtils.drawStringUnderlineCharAt(g2d, lines[i], -1, x, y);
            ++i;
            y += lheight + 1;
        }
        g2d.dispose();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        TextInfo info = this.getTextInfo(c);
        Insets ins = c.getInsets();
        return new Dimension(info.getMaxWidth() + ins.left + ins.right, info.getLines().length * (info.getLineHeight() + 1) + ins.top + ins.bottom);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(5000, 5000);
    }

    private TextInfo getTextInfo(JComponent c) {
        MultiLineLabel label = (MultiLineLabel)c;
        return new TextInfo(label);
    }

    private class TextInfo {
        private int lineAscent_;
        private int lineHeight_;
        private int numLines_;
        private String[] lines_;
        private int[] lineWidths_;
        private int maxWidth_;

        protected TextInfo(MultiLineLabel label) {
            FontMetrics fm = label.getFontMetrics(label.getFont());
            this.lineHeight_ = fm.getHeight();
            this.lineAscent_ = fm.getAscent();
            this.maxWidth_ = 0;
            String text = label.getText().replaceFirst("^\\n+", "");
            this.lines_ = text.split("\\n");
            this.numLines_ = this.lines_.length;
            this.lineWidths_ = new int[this.numLines_];
            for (int i = 0; i < this.numLines_; ++i) {
                this.lineWidths_[i] = fm.stringWidth(this.lines_[i]);
                this.maxWidth_ = Math.max(this.maxWidth_, this.lineWidths_[i]);
            }
        }

        public int getLineAscent() {
            return this.lineAscent_;
        }

        public int getLineHeight() {
            return this.lineHeight_;
        }

        public String[] getLines() {
            return this.lines_;
        }

        public int[] getLineWidths() {
            return this.lineWidths_;
        }

        public int getMaxWidth() {
            return this.maxWidth_;
        }
    }
}

