/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.plaf;

import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.plaf.GissComboBoxRenderer;
import gov.nasa.giss.ui.plaf.GissComboPopup;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class GissComboBoxUI
extends BasicComboBoxUI {
    private static final int DEFAULT_WIDTH = 100;
    private static long timeFactor_ = 1000L;
    protected JComboBox<Object> falseButton_;

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.falseButton_ = new FalseButton<Object>();
        ListCellRenderer renderer = this.comboBox.getRenderer();
        this.falseButton_.setRenderer(renderer);
        if (PlatformUtils.isMacintosh()) {
            Object sv = this.comboBox.getClientProperty("JComponent.sizeVariant");
            if (sv != null) {
                this.falseButton_.putClientProperty("JComponent.sizeVariant", (String)sv);
                if (this.popup != null) {
                    GissComboPopup gcp = (GissComboPopup)this.popup;
                    gcp.setFont(this.falseButton_.getFont());
                    gcp.putClientProperty("JComponent.sizeVariant", (String)sv);
                }
            }
            this.comboBox.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    String pname = e.getPropertyName();
                    if (pname.equals("JComponent.sizeVariant")) {
                        GissComboBoxUI.this.falseButton_.putClientProperty(pname, e.getNewValue());
                        GissComboPopup gcp = (GissComboPopup)GissComboBoxUI.this.popup;
                        gcp.setFont(GissComboBoxUI.this.falseButton_.getFont());
                        gcp.putClientProperty("JComponent.sizeVariant", e.getNewValue());
                    }
                }
            });
        }
        this.comboBox.addAncestorListener(new FocusAttacher());
        this.comboBox.addMouseListener(new FocusGrabber());
        this.comboBox.setKeySelectionManager(new GCBKeySelectionManager());
        Long lll = (Long)UIManager.get("ComboBox.timeFactor");
        timeFactor_ = lll == null ? 1000L : lll;
    }

    @Override
    protected ComboPopup createPopup() {
        JComboBox cb = this.comboBox;
        GissComboPopup gcp = new GissComboPopup(cb);
        return gcp;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        PopupMenuListener popupMenuListener_ = this.createPopupMenuListener();
        this.comboBox.addPopupMenuListener(popupMenuListener_);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
    }

    private PopupMenuListener createPopupMenuListener() {
        return new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                GissComboBoxUI.this.arrowButton.getModel().setPressed(true);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                GissComboBoxUI.this.arrowButton.getModel().setPressed(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        };
    }

    @Override
    protected ListCellRenderer<Object> createRenderer() {
        return new GissComboBoxRenderer();
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.falseButton_.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.falseButton_.getPreferredSize();
    }

    @Override
    protected Dimension getDefaultSize() {
        return new Dimension(100, this.falseButton_.getPreferredSize().height);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        GuiUtils.updateGraphicsIfDisabled((Graphics2D)g, c);
        ListCellRenderer renderer = this.comboBox.getRenderer();
        this.falseButton_.setRenderer(renderer);
        this.falseButton_.paint(g);
    }

    @Override
    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
    }

    @Override
    protected Dimension getDisplaySize() {
        int maxWidth = this.comboBox.getPrototypeDisplayValue() != null ? this.getItemDisplayWidth(this.comboBox.getPrototypeDisplayValue()) : (this.comboBox.getItemCount() > 0 ? this.getMaxComboBoxModelDisplayWidth() : this.getDefaultSize().width);
        Insets ins = this.falseButton_.getInsets();
        return new Dimension(maxWidth += ins.left + ins.right, this.falseButton_.getPreferredSize().height);
    }

    private int getMaxComboBoxModelDisplayWidth() {
        int maxWidth = 0;
        int isize = this.comboBox.getModel().getSize();
        for (int i = 0; i < isize; ++i) {
            int itemWidth = this.getItemDisplayWidth(this.comboBox.getModel().getElementAt(i));
            maxWidth = Math.max(maxWidth, itemWidth);
        }
        return maxWidth;
    }

    private int getItemDisplayWidth(Object item) {
        Objects.requireNonNull(item, "Object cannot be null.");
        String text = item.toString();
        ListCellRenderer lcr = this.comboBox.getRenderer();
        if (lcr instanceof GissComboBoxRenderer) {
            GissComboBoxRenderer gcbr = (GissComboBoxRenderer)lcr;
            gcbr.setText(text);
            gcbr.setFont(this.falseButton_.getFont());
            Dimension d = gcbr.getPreferredSize();
            return d.width;
        }
        FontMetrics fm = this.comboBox.getFontMetrics(this.comboBox.getFont());
        return fm.stringWidth(text) + 64;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(GissComboBoxUI.this.falseButton_.getPreferredSize());
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return new Dimension(GissComboBoxUI.this.falseButton_.getPreferredSize());
            }

            @Override
            public void layoutContainer(Container parent) {
                GissComboBoxUI.this.falseButton_.setSize(parent.getSize());
                GissComboBoxUI.this.falseButton_.doLayout();
            }
        };
    }

    class GCBKeySelectionManager
    implements JComboBox.KeySelectionManager,
    UIResource {
        private long lastTime;
        private long time;
        private String prefix = "";
        private String typedString = "";

        GCBKeySelectionManager() {
        }

        public int selectionForKey(char aKey, ComboBoxModel aModel) {
            if (this.lastTime == 0L) {
                this.prefix = "";
                this.typedString = "";
            }
            this.time = System.currentTimeMillis();
            this.typedString = this.time - this.lastTime < timeFactor_ ? this.typedString + aKey : String.valueOf(aKey);
            int length = this.typedString.length();
            this.lastTime = this.time;
            int result = -1;
            int isize = aModel.getSize();
            for (int i = 0; i < isize; ++i) {
                String s;
                String ss;
                int cc;
                Object o = aModel.getElementAt(i);
                if (o == null || (cc = (ss = (s = o.toString()).length() > length ? s.substring(0, length) : s).compareToIgnoreCase(this.typedString)) != 0) continue;
                result = i;
                break;
            }
            if (result < 0) {
                return result;
            }
            if (GissComboBoxUI.this.popup.isVisible()) {
                ((GissComboPopup)GissComboBoxUI.this.popup).highlight(result);
            } else {
                ((GissComboPopup)GissComboBoxUI.this.popup).show(result);
            }
            return -1;
        }
    }

    class FocusAdapter
    extends WindowAdapter {
        FocusAdapter() {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            this.hidePopupMenu();
        }

        @Override
        public void windowIconified(WindowEvent e) {
            this.hidePopupMenu();
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            this.hidePopupMenu();
        }

        private void hidePopupMenu() {
            if (GissComboBoxUI.this.popup.isVisible()) {
                ((GissComboPopup)GissComboBoxUI.this.popup).hide();
            }
        }
    }

    class FocusAttacher
    implements AncestorListener {
        FocusAttacher() {
        }

        @Override
        public void ancestorAdded(AncestorEvent e) {
            Window w;
            if (GissComboBoxUI.this.comboBox != null && (w = GuiUtils.getParentWindow(GissComboBoxUI.this.comboBox)) != null) {
                w.addWindowListener(new FocusAdapter());
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent e) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent e) {
        }
    }

    class FocusGrabber
    extends MouseAdapter {
        FocusGrabber() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (GissComboBoxUI.this.comboBox == null) {
                return;
            }
            if (GissComboBoxUI.this.comboBox.isEnabled()) {
                GissComboBoxUI.this.comboBox.grabFocus();
            }
        }
    }

    class FalseButton<E>
    extends JComboBox<E> {
        FalseButton() {
            super(GissComboBoxUI.this.comboBox.getModel());
            this.setDoubleBuffered(false);
            this.setOpaque(false);
        }

        @Override
        public boolean isFocusOwner() {
            if (GissComboBoxUI.this.popup == null) {
                return false;
            }
            return GissComboBoxUI.this.comboBox.isFocusOwner();
        }

        @Override
        public boolean hasFocus() {
            return this.isFocusOwner();
        }
    }
}

