/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.panel;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.ui.GuiUtils;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public class HudPseudoPalette
extends JPanel {
    private static final Color BACKGROUND = new Color(0, 0, 0, 204);
    private static final Color HIGHLIGHT = new Color(255, 255, 255, 59);
    private static final Color HIGHLIGHT_BOTTOM = new Color(255, 255, 255, 25);
    private static final Color TOP_BACKGROUND_TOP = new Color(255, 255, 255, 59);
    private static final Color TOP_BACKGROUND_MIDDLE = new Color(196, 196, 196, 59);
    private static final Color BOTTOM_BACKGROUND = new Color(255, 255, 255, 30);
    private static final int TITLE_HEIGHT = 22;
    private static final int CORNER_DIAMETER = 16;
    private String title_;
    private int titleWidth_;
    private int lineHeight_;
    private int lineAscent_;
    private boolean open_ = true;
    private Border innerBorder_;
    private Border outerBorder_;

    public HudPseudoPalette() {
        this.setTitle("HUD");
        this.setOpaque(false);
        this.setFont(UIManager.getDefaults().getFont("Label.font"));
        this.setBorder(null);
        this.outerBorder_ = BorderFactory.createEmptyBorder(26, 4, 4, 4);
        this.setInnerBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        PaletteMouseHandler mph = new PaletteMouseHandler();
        this.addMouseListener(mph);
        this.addMouseMotionListener(mph);
    }

    public String getTitle() {
        return this.title_;
    }

    public void setTitle(String title) {
        this.title_ = title;
        this.setName(title);
        this.measure();
    }

    public boolean isOpen() {
        return this.open_;
    }

    public void setOpen(boolean open) {
        this.open_ = open;
        this.setSize(this.getPreferredSize());
        this.invalidate();
        Container c = this.getParent();
        if (c != null) {
            c.repaint();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (!this.open_) {
            d.height = 22;
        }
        return d;
    }

    @Override
    public void setBorder(Border b) {
    }

    public void setInnerBorder(Border b) {
        this.innerBorder_ = b;
        super.setBorder(BorderFactory.createCompoundBorder(this.outerBorder_, this.innerBorder_));
    }

    public Border getInnerBorder() {
        return this.innerBorder_;
    }

    @Override
    protected void paintBorder(Graphics g) {
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        int w = this.getWidth();
        int h = this.getHeight();
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, HIGHLIGHT, 0.0f, h, HIGHLIGHT_BOTTOM);
        g2d.setPaint(paint);
        g2d.drawRoundRect(0, 0, w - 1, h - 1, 16, 16);
        g2d.dispose();
        super.paintBorder(g);
    }

    @Override
    public void paintChildren(Graphics g) {
        if (!this.open_) {
            return;
        }
        super.paintChildren(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = GraphicUtils.createAntialiasedGfx(g);
        int w = this.getWidth();
        int h = this.getHeight();
        g2d.setColor(BACKGROUND);
        g2d.fillRoundRect(0, 0, w, h, 16, 16);
        if (GuiUtils.isParentWindowFocused(this) && this.getParent().getComponentZOrder(this) == 0) {
            Area titleBottom;
            Area titleRoundRect = new Area(new RoundRectangle2D.Double(0.0, 0.0, w, 22.0, 16.0, 16.0));
            Area titleTopRect = new Area(new Rectangle(0, 0, w, 11));
            Area titleBottomRect = new Area(new Rectangle(0, 11, w, 11));
            Area titleTop = (Area)titleRoundRect.clone();
            titleTop.subtract(titleBottomRect);
            if (this.open_) {
                titleBottom = titleBottomRect;
            } else {
                titleBottom = (Area)titleRoundRect.clone();
                titleBottom.subtract(titleTopRect);
            }
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, TOP_BACKGROUND_TOP, 0.0f, 11.0f, TOP_BACKGROUND_MIDDLE);
            g2d.setPaint(paint);
            g2d.fill(titleTop);
            g2d.setColor(BOTTOM_BACKGROUND);
            g2d.fill(titleBottom);
            g2d.setColor(HIGHLIGHT_BOTTOM);
        } else {
            g2d.setColor(HIGHLIGHT);
        }
        g2d.drawLine(0, 21, w, 21);
        if (this.titleWidth_ > 0) {
            int x = Math.max(0, (w - this.titleWidth_) / 2);
            int y = (22 - this.lineHeight_) / 2 + this.lineAscent_;
            g2d.setColor(Color.WHITE);
            g2d.drawString(this.title_, x, y);
        }
        g2d.dispose();
    }

    private void measure() {
        if (this.title_ == null || this.title_.length() == 0) {
            this.titleWidth_ = 0;
        } else {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            this.lineHeight_ = fm.getHeight();
            this.lineAscent_ = fm.getAscent();
            this.titleWidth_ = fm.stringWidth(this.title_);
        }
    }

    public class PaletteMouseHandler
    extends MouseInputAdapter {
        private boolean dragInProgress_;
        private Point windowPoint_;
        private Point mousePoint_;

        private void movePalette(Point p) {
            if (!this.dragInProgress_) {
                return;
            }
            int dx = p.x - this.mousePoint_.x;
            int dy = p.y - this.mousePoint_.y;
            this.windowPoint_.translate(dx, dy);
            HudPseudoPalette.this.setLocation(this.windowPoint_);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Container c = HudPseudoPalette.this.getParent();
            if (e.getClickCount() == 2 && e.getPoint().y < 22) {
                HudPseudoPalette.this.setOpen(!HudPseudoPalette.this.isOpen());
            } else {
                c.setComponentZOrder(HudPseudoPalette.this, 0);
            }
            c.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.movePalette(e.getPoint());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getPoint().y > 22) {
                return;
            }
            this.dragInProgress_ = true;
            this.windowPoint_ = HudPseudoPalette.this.getLocation();
            this.mousePoint_ = e.getPoint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.movePalette(e.getPoint());
            this.dragInProgress_ = false;
        }
    }
}

