/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui;

import gov.nasa.giss.ui.BrushMetalUtils;
import gov.nasa.giss.ui.WindowDragger;
import gov.nasa.giss.ui.border.FocusStateMatteBorder;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class Toolbar
extends Box {
    private static final Border BORDER = BorderFactory.createEmptyBorder(8, 8, 8, 8);
    private static Border innerBorder_;
    private static FocusStateMatteBorder outerBorder_;

    public Toolbar() {
        this(0);
    }

    public Toolbar(int alignment) {
        super(alignment);
        this.setBorder(BORDER);
        if (PlatformUtils.isMacintosh()) {
            this.setOpaque(false);
            WindowDragger dragger = new WindowDragger(this);
            this.addMouseListener(dragger);
            this.addMouseMotionListener(dragger);
        } else {
            this.setOpaque(true);
            Color cc = UIManager.getColor("Panel.background");
            if (cc != null) {
                this.setBackground(cc);
            } else {
                this.setBackground(new Color(238, 238, 238));
            }
        }
    }

    public void setShowBottomEdge(boolean show) {
        if (show) {
            super.setBorder(BorderFactory.createCompoundBorder(outerBorder_, innerBorder_));
        } else {
            super.setBorder(innerBorder_);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    static {
        Color focusedColor = BrushMetalUtils.getShadowColor(true);
        Color unfocusedColor = BrushMetalUtils.getShadowColor(false);
        innerBorder_ = BorderFactory.createEmptyBorder(8, 2, 8, 2);
        outerBorder_ = new FocusStateMatteBorder(0, 0, 1, 0, focusedColor, unfocusedColor);
    }
}

