/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time.mission;

import gov.nasa.giss.time.JDCalendar;
import gov.nasa.giss.time.UTParser;
import gov.nasa.giss.time.mission.MarsLanderTime;
import gov.nasa.giss.time.mission.MissionStatus;
import gov.nasa.giss.time.planet.MarsTime;
import java.util.Date;

public class MarsScienceLaboratory
extends MarsLanderTime {
    private static final String LAUNCH_STRING = "2011-11-26 15:02:00";
    private static final String SOL0_STRING = "2012-08-05 13:49:59";
    private static final String DESCENT_STRING = "2012-08-06 05:10:00";
    private static final String LANDING_STRING = "2012-08-06 05:17:55";
    private long launchMillis_;
    private long solInitMillis_;
    private long descentMillis_;
    private long landingMillis_;

    public MarsScienceLaboratory() {
        super("MSL Curiosity");
        this.initialize();
    }

    public MarsScienceLaboratory(MarsTime marsTime) {
        this();
        this.setPlanetTime(marsTime);
    }

    private void initialize() {
        Date launchDate = UTParser.parse(LAUNCH_STRING);
        Date sol0Date = UTParser.parse(SOL0_STRING);
        Date descentDate = UTParser.parse(DESCENT_STRING);
        Date landingDate = UTParser.parse(LANDING_STRING);
        JDCalendar jdc = new JDCalendar();
        jdc.setTime(launchDate);
        this.launchMillis_ = jdc.getTimeInMillis();
        jdc.setTime(sol0Date);
        this.solInitMillis_ = jdc.getTimeInMillis();
        jdc.setTime(descentDate);
        this.descentMillis_ = jdc.getTimeInMillis();
        jdc.setTime(landingDate);
        this.landingMillis_ = jdc.getTimeInMillis();
    }

    @Override
    protected void update() {
        long millis = this.mTime_.getMillis();
        if (millis < this.launchMillis_) {
            this.status_ = MissionStatus.NOT_LAUNCHED;
            this.sol_ = Long.MIN_VALUE;
            this.fraction_ = 0.0;
        } else {
            double lltSec = (double)(millis - this.solInitMillis_) * 0.001 * 0.9732442960905843;
            double llt = lltSec * 1.1574074074074073E-5;
            this.sol_ = (long)Math.floor(llt);
            this.fraction_ = llt - (double)this.sol_;
            this.status_ = millis < this.descentMillis_ ? MissionStatus.IN_FLIGHT : (millis < this.landingMillis_ ? MissionStatus.DESCENDING : MissionStatus.ACTIVE);
        }
        this.needsUpdate_ = false;
    }

    public long timeToLanding() {
        long millis = this.mTime_.getMillis();
        return this.landingMillis_ - millis;
    }
}

