/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time.mission;

public enum MarsLanderID {
    VL1("Viking Lander 1"),
    VL2("Viking Lander 2"),
    MPF("Mars Pathfinder"),
    MERA("MER-A Spirit"),
    MERB("MER-B Opportunity"),
    PHX("Mars Phoenix"),
    MSL("MSL Curiosity"),
    NSYT("InSight"),
    M20("Perseverance");

    private String fullName_;

    private MarsLanderID(String fullName) {
        this.fullName_ = fullName;
    }

    public String toString() {
        return this.fullName_;
    }

    public boolean matches(String str) {
        return this.nameMatches(str) | this.fullNameMatches(str);
    }

    public boolean nameMatches(String str) {
        return this.name().equalsIgnoreCase(str);
    }

    public boolean fullNameMatches(String str) {
        return this.fullName_.equalsIgnoreCase(str);
    }

    public static MarsLanderID matching(String str) {
        for (MarsLanderID id : MarsLanderID.values()) {
            if (!id.matches(str)) continue;
            return id;
        }
        return null;
    }
}

