/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.prefs;

import gov.nasa.giss.prefs.PreferencesEvent;
import gov.nasa.giss.prefs.PreferencesHash;
import gov.nasa.giss.prefs.PreferencesListener;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.util.PlatformUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.nio.channels.FileChannel;
import javax.swing.event.EventListenerList;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPreferences
extends PreferencesHash {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String appName_;
    private String domain_;
    private String altdir_;
    private int prefsVersion_;
    private File prefsDir_;
    private File prefsFile_;
    private File settingsFile_;
    private static boolean prefsFileDisabled_;
    private EventListenerList listenerList_ = new EventListenerList();

    protected AbstractPreferences() {
        throw new RuntimeException("Use another constructor");
    }

    protected AbstractPreferences(String appName, String domain, String altdir) {
        this(appName, domain, altdir, -1);
    }

    protected AbstractPreferences(String appName, String domain, String altdir, int version) {
        this.appName_ = appName;
        this.domain_ = domain;
        this.altdir_ = altdir;
        this.prefsVersion_ = version;
        this.setName(appName);
        this.restoreDefaults();
    }

    public String getAppName() {
        return this.appName_;
    }

    public static void disablePreferencesFile() {
        prefsFileDisabled_ = true;
    }

    public static boolean isPreferencesFileDisabled() {
        return prefsFileDisabled_;
    }

    public void read() {
        if (prefsFileDisabled_) {
            LOGGER.warn("Prefs file usage has been disabled.");
            LOGGER.warn("Prefs will start at factory default values and no prefs changes will be saved.");
            return;
        }
        if (this.appName_ == null) {
            LOGGER.warn("No app name available to determine preferences file location.");
            LOGGER.warn("Prefs will start at factory default values and no prefs changes will be saved.");
            return;
        }
        this.prefsDir_ = this.findPrefsDirectory();
        if (this.prefsDir_ == null) {
            LOGGER.warn("Unable to create prefs directory object.");
            LOGGER.warn("Prefs will start at factory default values and no prefs changes will be saved.");
            return;
        }
        this.prefsFile_ = this.findPrefsFile(this.prefsVersion_);
        if (this.prefsFile_ == null) {
            LOGGER.warn("Unable to create prefs file object.");
            LOGGER.warn("Prefs will start at factory default values and no prefs changes will be saved.");
            return;
        }
        boolean prefsRead = false;
        if (this.prefsFile_.exists()) {
            LOGGER.trace("Attempting to read prefs at {}", (Object)this.prefsFile_.getName());
            this.read(this.prefsFile_);
            prefsRead = true;
        } else if (this.prefsVersion_ > 0) {
            File prevFile;
            if (this.prefsVersion_ > 1 && (prevFile = this.findPrefsFile(this.prefsVersion_ - 1)).exists()) {
                LOGGER.trace("Attempting to read prefs at {}", (Object)prevFile.getName());
                this.read(prevFile);
                prefsRead = true;
            }
            if (!prefsRead && (prevFile = this.findPrefsFile(0)).exists()) {
                LOGGER.trace("Attempting to read prefs at {}", (Object)prevFile.getName());
                this.read(prevFile);
                prefsRead = true;
            }
        }
        if (!this.prefsFile_.exists()) {
            try {
                this.save(this.prefsFile_);
            }
            catch (Exception exc) {
                LOGGER.warn("Unable to create preferences file.");
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
                this.prefsFile_ = null;
            }
        }
    }

    private File findPrefsDirectory() {
        String homeDir = System.getProperty("user.home");
        String pathSep = System.getProperty("file.separator");
        Object prefsDname = null;
        prefsDname = PlatformUtils.isMacintosh() ? homeDir + pathSep + "Library" + pathSep + "Preferences" : (this.altdir_ != null ? homeDir + pathSep + this.altdir_ : homeDir + pathSep + ".xjava");
        File prefsDir = null;
        try {
            prefsDir = new File((String)prefsDname);
        }
        catch (Exception exc) {
            LOGGER.warn("Exception while creating prefs directory object: {}", (Object)exc.toString());
            return null;
        }
        if (prefsDir == null) {
            LOGGER.warn("Somehow got null creating prefs directory object.");
            return null;
        }
        if (!prefsDir.exists()) {
            LOGGER.trace("Attempting to create preferences directory.");
            prefsDir.mkdirs();
        }
        if (!prefsDir.exists()) {
            LOGGER.warn("Unable to create preferences directory.");
            return null;
        }
        return prefsDir;
    }

    private File findPrefsFile(int version) {
        StringBuilder fileSB;
        if (this.domain_ == null) {
            throw new RuntimeException("Prefs domain has not been set.");
        }
        if (this.appName_ == null) {
            throw new RuntimeException("Application name has not been set.");
        }
        if (prefsFileDisabled_) {
            LOGGER.warn("Prefs file usage has been disabled.");
            return null;
        }
        String prefsFname = null;
        if (PlatformUtils.isMacintosh()) {
            fileSB = new StringBuilder(this.domain_).append(".").append(this.appName_);
            if (version > 0) {
                fileSB.append(".").append(version);
            }
            fileSB.append(".prefs.xml");
            prefsFname = fileSB.toString();
        } else {
            fileSB = new StringBuilder(this.appName_.toLowerCase());
            if (version > -1) {
                fileSB.append(".").append(version);
            }
            fileSB.append(".xml");
            prefsFname = fileSB.toString();
        }
        File prefsFile = null;
        try {
            prefsFile = new File(this.prefsDir_, prefsFname);
        }
        catch (Exception exc) {
            LOGGER.warn("Exception while creating prefs file object: {}", (Object)exc.toString());
            return null;
        }
        if (prefsFile == null) {
            LOGGER.warn("Somehow got null creating prefs file object.");
            return null;
        }
        return prefsFile;
    }

    public synchronized void read(File f) {
        block8: {
            if (f == null || !f.exists()) {
                LOGGER.warn("Null/non-existent prefs file.");
                return;
            }
            this.settingsFile_ = f;
            try (FileInputStream is = new FileInputStream(this.settingsFile_);){
                this.readStream(is);
            }
            catch (Exception exc) {
                LOGGER.warn("Exception reading prefs. Ignoring past settings");
                if (!LOGGER.isDebugEnabled()) break block8;
                exc.printStackTrace();
            }
        }
    }

    public void revert() {
        LOGGER.debug("");
        if (this.settingsFile_ != null) {
            this.read(this.settingsFile_);
        } else if (this.prefsFile_ != null) {
            this.read(this.prefsFile_);
        } else {
            this.restoreDefaults();
        }
    }

    public abstract void restoreDefaults();

    protected abstract void readStream(InputStream var1) throws IOException, JDOMException;

    @Override
    public void set(String key, Object value) {
        super.set(key, value);
        this.firePreferenceChanged(key);
    }

    public void save() {
        File backup;
        block33: {
            block32: {
                if (prefsFileDisabled_) {
                    LOGGER.warn("Prefs file usage has been disabled.");
                    return;
                }
                if (this.prefsFile_ == null) {
                    LOGGER.warn("No prefs file has been identified.");
                    return;
                }
                backup = null;
                try {
                    String bkpName = this.prefsFile_.toString() + "_bkp";
                    backup = new File(bkpName);
                }
                catch (Exception exc) {
                    backup = null;
                }
                if (backup != null) {
                    try (FileInputStream fis = new FileInputStream(this.prefsFile_);
                         FileOutputStream fos = new FileOutputStream(backup);
                         FileChannel inputChannel = fis.getChannel();
                         FileChannel outputChannel = fos.getChannel();){
                        outputChannel.transferFrom(inputChannel, 0L, inputChannel.size());
                    }
                    catch (Exception exc) {
                        LOGGER.warn("Exception saving prefs backup: {}", (Object)exc.toString());
                        if (!LOGGER.isTraceEnabled()) break block32;
                        exc.printStackTrace();
                    }
                }
            }
            try {
                this.save(this.prefsFile_);
            }
            catch (Exception exc) {
                LOGGER.warn("Exception saving preferences: {}", exc);
                if (!LOGGER.isTraceEnabled()) break block33;
                exc.printStackTrace();
            }
        }
        if (backup != null && backup.exists()) {
            backup.delete();
        }
    }

    public void save(File f) {
        block9: {
            try (FileOutputStream fos = new FileOutputStream(f);){
                this.saveStream(fos);
            }
            catch (Exception exc) {
                if (PlatformUtils.isHeadless()) {
                    LOGGER.warn("Exception writing prefs: {}", (Object)exc.toString());
                } else {
                    GuiUtils.showSlowMessage(null, "File Error", "I encountered an error while savings preferences.\n" + exc.toString());
                }
                if (!LOGGER.isDebugEnabled()) break block9;
                exc.printStackTrace();
            }
        }
    }

    protected abstract void saveStream(OutputStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreferenceListener(PreferencesListener l) {
        EventListenerList eventListenerList = this.listenerList_;
        synchronized (eventListenerList) {
            this.listenerList_.add(PreferencesListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePreferenceListener(PreferencesListener l) {
        EventListenerList eventListenerList = this.listenerList_;
        synchronized (eventListenerList) {
            this.listenerList_.remove(PreferencesListener.class, l);
        }
    }

    protected void firePreferenceChanged(String pname) {
        Object o = this.get(pname);
        PreferencesEvent e = new PreferencesEvent(pname, o);
        Object[] list = this.listenerList_.getListenerList();
        for (int i = 0; i < list.length; ++i) {
            if (!(list[i] instanceof PreferencesListener)) continue;
            ((PreferencesListener)list[i]).preferenceChanged(e);
        }
    }
}

