/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.data.nc.NcConfig;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.server.PanServer;
import gov.nasa.giss.panoply.util.PanLoggingUtils;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanQuitHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static boolean quitting_;

    public static void quit() {
        block9: {
            block8: {
                if (quitting_) {
                    return;
                }
                quitting_ = true;
                LOGGER.info("Panoply is shutting down.");
                try {
                    PanPreferences.getSharedInstance().save();
                }
                catch (Exception exc) {
                    LOGGER.warn("Failed to save preferences due to exception.");
                    if (!LOGGER.isDebugEnabled()) break block8;
                    exc.printStackTrace();
                }
            }
            try {
                if (PanServer.instanceExists()) {
                    PanServer.getSharedInstance().close();
                }
            }
            catch (Exception exc) {
                LOGGER.warn("Failed to halt 'server' instance due to exception.");
                if (!LOGGER.isDebugEnabled()) break block9;
                exc.printStackTrace();
            }
        }
        try {
            NcConfig.clearCache();
        }
        catch (Exception exc) {
            LOGGER.warn("Failed to clear NJ cache due to exception.");
        }
        PanLoggingUtils.closeLogfile();
        System.exit(0);
    }

    public static boolean isQuitting() {
        return quitting_;
    }

    private PanQuitHandler() {
    }
}

