/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.util.DescribedItem;

public enum PanGridLabelStep implements DescribedItem
{
    NONE(0, "None"),
    EVERY(1, "Every grid line"),
    SECOND(2, "Every other grid line"),
    THIRD(3, "Every third grid line"),
    FOURTH(4, "Every fourth grid line"),
    FIFTH(5, "Every fifth grid line");

    private final int step_;
    private final String description_;

    private PanGridLabelStep(int step, String description) {
        this.step_ = step;
        this.description_ = description;
    }

    public int getStep() {
        return this.step_;
    }

    @Override
    public String getDescription() {
        return this.description_;
    }

    public String toString() {
        return this.description_;
    }

    @Override
    public boolean matches(String text) {
        if (this.name().equalsIgnoreCase(text) || this.description_.equalsIgnoreCase(text)) {
            return true;
        }
        try {
            int ii = Integer.valueOf(text);
            return this.matches(ii);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean matches(int step) {
        return step == this.step_;
    }

    public static PanGridLabelStep matching(int str) {
        for (PanGridLabelStep item : PanGridLabelStep.values()) {
            if (!item.matches(str)) continue;
            return item;
        }
        return NONE;
    }
}

