/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.panoply.util.PanProperties;

public final class PanDevoMode {
    private static final boolean VERSION_5;
    private static final boolean USING_LOGFILE;
    private static final boolean BETA_MODE;
    private static final boolean DEVO_MODE;
    private static final boolean DEBUG_BORDERS = true;
    private static final boolean DEVO_LOG_E = false;

    public static boolean isUsingLogfile() {
        return USING_LOGFILE;
    }

    public static boolean isVersion5() {
        return VERSION_5;
    }

    public static boolean isBeta() {
        return BETA_MODE;
    }

    public static boolean isDevo() {
        return DEVO_MODE;
    }

    public static boolean isDebugBorders() {
        return DEVO_MODE;
    }

    public static boolean isDebugNoBuffering() {
        return BETA_MODE;
    }

    public static boolean isLogEScaleEnabled() {
        if (DEVO_MODE) {
            // empty if block
        }
        return false;
    }

    private PanDevoMode() {
    }

    static {
        USING_LOGFILE = PanProperties.VERSION_PROPS.getString("use-logfile").equalsIgnoreCase("true");
        VERSION_5 = PanProperties.VERSION_PROPS.getString("version").startsWith("5");
        DEVO_MODE = PanProperties.VERSION_PROPS.getString("is-devo").equalsIgnoreCase("true");
        BETA_MODE = DEVO_MODE ? true : PanProperties.VERSION_PROPS.getString("is-beta").equalsIgnoreCase("true");
    }
}

